/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.AbstractDictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.ObjectToSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;

public class MapDictionary<C>
extends AbstractDictionary<C>
implements Compilable,
Serializable {
    static final long serialVersionUID = 3296124888445414454L;
    final ObjectToSet<String, DictionaryEntry<C>> mPhraseToEntrySet;

    public MapDictionary() {
        this(new ObjectToSet<String, DictionaryEntry<C>>());
    }

    private MapDictionary(ObjectToSet<String, DictionaryEntry<C>> phraseToEntrySet) {
        this.mPhraseToEntrySet = phraseToEntrySet;
    }

    @Override
    public void addEntry(DictionaryEntry<C> entry) {
        this.mPhraseToEntrySet.addMember(entry.phrase(), entry);
    }

    @Override
    public Iterator<DictionaryEntry<C>> iterator() {
        return this.mPhraseToEntrySet.memberIterator();
    }

    @Override
    public Iterator<DictionaryEntry<C>> phraseEntryIt(String phrase) {
        return this.mPhraseToEntrySet.getSet(phrase).iterator();
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        out.writeObject(new Externalizer(this));
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    private static class Externalizer<D>
    extends AbstractExternalizable {
        private static final long serialVersionUID = -9136273040574611243L;
        final MapDictionary<D> mDictionary;

        public Externalizer() {
            this(null);
        }

        public Externalizer(MapDictionary<D> dictionary) {
            this.mDictionary = dictionary;
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            MapDictionary dict = new MapDictionary();
            int numEntries = in.readInt();
            int i = 0;
            while (i < numEntries) {
                DictionaryEntry entry = (DictionaryEntry)in.readObject();
                dict.addEntry(entry);
                ++i;
            }
            return dict;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mDictionary.size());
            for (DictionaryEntry<D> entry : this.mDictionary) {
                entry.compileTo(objOut);
            }
        }
    }
}

