/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.Dictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.util.Compilable;
import com.aliasi.util.Iterators;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDictionary<C>
extends AbstractSet<DictionaryEntry<C>>
implements Dictionary<C>,
Compilable {
    protected AbstractDictionary() {
    }

    @Override
    public Iterator<DictionaryEntry<C>> phraseEntryIt(String phrase) {
        return new PhraseIterator(phrase);
    }

    DictionaryEntry<C>[] phraseEntries(String phrase) {
        return this.itToEntries(this.phraseEntryIt(phrase));
    }

    @Override
    public List<DictionaryEntry<C>> phraseEntryList(String phrase) {
        return this.itToEntryList(this.phraseEntryIt(phrase));
    }

    @Override
    public Iterator<DictionaryEntry<C>> categoryEntryIt(C category) {
        return new CategoryIterator(category);
    }

    DictionaryEntry<C>[] categoryEntries(C category) {
        return this.itToEntries(this.categoryEntryIt(category));
    }

    @Override
    public List<DictionaryEntry<C>> categoryEntryList(C category) {
        return this.itToEntryList(this.categoryEntryIt(category));
    }

    @Override
    public int size() {
        return this.entries().length;
    }

    DictionaryEntry<C>[] entries() {
        return this.itToEntries(this.iterator());
    }

    @Override
    public List<DictionaryEntry<C>> entryList() {
        return this.itToEntryList(this.iterator());
    }

    @Override
    public void addEntry(DictionaryEntry<C> entry) {
        this.unsupported("addEntry(DictionaryEntry)");
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        this.unsupported("compileTo(ObjectOut)");
    }

    private void unsupported(String op) {
        String msg = "Unsupported operation=" + op + " Class=" + this.getClass();
        throw new UnsupportedOperationException(msg);
    }

    private List<DictionaryEntry<C>> itToEntryList(Iterator<DictionaryEntry<C>> it) {
        ArrayList<DictionaryEntry<C>> entryList = new ArrayList<DictionaryEntry<C>>();
        while (it.hasNext()) {
            entryList.add(it.next());
        }
        return entryList;
    }

    private DictionaryEntry<C>[] itToEntries(Iterator<DictionaryEntry<C>> it) {
        List<DictionaryEntry<C>> entryList = this.itToEntryList(it);
        DictionaryEntry[] entries = new DictionaryEntry[entryList.size()];
        entryList.toArray(entries);
        return entries;
    }

    private class CategoryIterator
    extends Iterators.Filter<DictionaryEntry<C>> {
        private final C mCategory;

        public CategoryIterator(C category) {
            super(AbstractDictionary.this.iterator());
            this.mCategory = category;
        }

        @Override
        public boolean accept(DictionaryEntry<C> entry) {
            return entry.category().equals(this.mCategory);
        }
    }

    private class PhraseIterator
    extends Iterators.Filter<DictionaryEntry<C>> {
        private final String mPhrase;

        public PhraseIterator(String phrase) {
            super(AbstractDictionary.this.iterator());
            this.mPhrase = phrase;
        }

        @Override
        public boolean accept(DictionaryEntry<C> entry) {
            return entry.phrase().equals(this.mPhrase);
        }
    }
}

