/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dca;

import com.aliasi.io.Reporter;
import com.aliasi.io.Reporters;
import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Matrices;
import com.aliasi.matrix.Vector;
import com.aliasi.stats.AnnealingSchedule;
import com.aliasi.stats.RegressionPrior;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Math;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

public class DiscreteChooser
implements Serializable {
    static final long serialVersionUID = 9199242060691577692L;
    private final Vector mCoefficients;

    public DiscreteChooser(Vector coefficients) {
        this.mCoefficients = coefficients;
    }

    public int choose(Vector[] choices) {
        DiscreteChooser.verifyNonEmpty(choices);
        if (choices.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        double maxScore = this.linearBasis(choices[0]);
        int i = 1;
        while (i < choices.length) {
            double score = this.linearBasis(choices[i]);
            if (score > maxScore) {
                maxScore = score;
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public double[] choiceProbs(Vector[] choices) {
        DiscreteChooser.verifyNonEmpty(choices);
        double[] scores = this.choiceLogProbs(choices);
        int i = 0;
        while (i < scores.length) {
            scores[i] = java.lang.Math.exp(scores[i]);
            ++i;
        }
        return scores;
    }

    public double[] choiceLogProbs(Vector[] choices) {
        DiscreteChooser.verifyNonEmpty(choices);
        double[] scores = new double[choices.length];
        int i = 0;
        while (i < choices.length) {
            scores[i] = this.mCoefficients.dotProduct(choices[i]);
            ++i;
        }
        double Z = Math.logSumOfExponentials(scores);
        int i2 = 0;
        while (i2 < choices.length) {
            int n = i2++;
            scores[n] = scores[n] - Z;
        }
        return scores;
    }

    public Vector coefficients() {
        return Matrices.unmodifiableVector(this.mCoefficients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscreteChoose(");
        int[] nzDims = this.mCoefficients.nonZeroDimensions();
        int i = 0;
        while (i < nzDims.length) {
            int d = nzDims[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Integer.toString(d));
            sb.append('=');
            sb.append(Double.toString(this.mCoefficients.value(d)));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    double linearBasis(Vector v) {
        return v.dotProduct(this.mCoefficients);
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    public static DiscreteChooser estimate(Vector[][] alternativess, int[] choices, RegressionPrior prior, int priorBlockSize, AnnealingSchedule annealingSchedule, double minImprovement, int minEpochs, int maxEpochs, Reporter reporter) {
        if (reporter == null) {
            reporter = Reporters.silent();
        }
        int numTrainingInstances = alternativess.length;
        reporter.info("estimate()");
        reporter.info("# training cases=" + numTrainingInstances);
        reporter.info("regression prior=" + prior);
        reporter.info("annealing schedule=" + annealingSchedule);
        reporter.info("min improvement=" + minImprovement);
        reporter.info("min epochs=" + minEpochs);
        reporter.info("max epochs=" + maxEpochs);
        if (alternativess.length == 0) {
            String msg = "Require at least 1 training instance.   Found alternativess.length=0";
            throw new IllegalArgumentException(msg);
        }
        if (alternativess.length != choices.length) {
            String msg = "Alternatives and choices must be the same length. Found alternativess.length=" + alternativess.length + " choices.length=" + choices.length;
            throw new IllegalArgumentException(msg);
        }
        int i = 0;
        while (i < alternativess.length) {
            if (alternativess[i].length < 1) {
                String msg = "Require at least one alternative. Found alternativess[" + i + "].length=0";
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        i = 0;
        while (i < alternativess.length) {
            if (choices[i] < 0) {
                String msg = "Choices must be non-negative. Found choices[" + i + "]=" + choices[i];
                throw new IllegalArgumentException(msg);
            }
            if (choices[i] > alternativess[i].length) {
                String msg = "Choices must be less than alts length. Found choices[" + i + "]=" + choices[i] + " alternativess[" + i + "].length=" + alternativess.length + ".";
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        int numDimensions = alternativess[0][0].numDimensions();
        int i2 = 0;
        while (i2 < alternativess.length) {
            int j = 0;
            while (j < alternativess[i2].length) {
                if (numDimensions != alternativess[i2][j].numDimensions()) {
                    String msg = "All alternatives must be same length. alternativess[0][0].length=" + numDimensions + " alternativess[" + i2 + "][" + j + "]=" + alternativess[i2][j] + ".";
                    throw new IllegalArgumentException(msg);
                }
                ++j;
            }
            ++i2;
        }
        DenseVector coefficientVector = new DenseVector(numDimensions);
        DiscreteChooser chooser = new DiscreteChooser(coefficientVector);
        double lastLlp = Double.NaN;
        double rollingAverageRelativeDiff = 1.0;
        double bestLlp = Double.NEGATIVE_INFINITY;
        int epoch = 0;
        while (epoch < maxEpochs) {
            block28: {
                double learningRate = annealingSchedule.learningRate(epoch);
                int j = 0;
                while (j < numTrainingInstances) {
                    Vector[] alternatives = alternativess[j];
                    int choice = choices[j];
                    double[] probs = chooser.choiceProbs(alternatives);
                    int k = 0;
                    while (k < alternatives.length) {
                        double condProbMinusTruth;
                        double d = condProbMinusTruth = choice == k ? probs[k] - 1.0 : probs[k];
                        if (condProbMinusTruth != 0.0) {
                            coefficientVector.increment(-learningRate * condProbMinusTruth, alternatives[k]);
                        }
                        ++k;
                    }
                    if (j % priorBlockSize == 0) {
                        DiscreteChooser.updatePrior(prior, coefficientVector, learningRate * (double)priorBlockSize / (double)numTrainingInstances);
                    }
                    ++j;
                }
                DiscreteChooser.updatePrior(prior, coefficientVector, learningRate * (double)(numTrainingInstances % priorBlockSize) / (double)numTrainingInstances);
                double ll = DiscreteChooser.logLikelihood(chooser, alternativess, choices);
                double lp = Math.logBase2ToNaturalLog(prior.log2Prior(coefficientVector));
                double llp = ll + lp;
                if (llp > bestLlp) {
                    bestLlp = llp;
                }
                if (epoch > 0) {
                    double relativeDiff = Math.relativeAbsoluteDifference(lastLlp, llp);
                    rollingAverageRelativeDiff = (9.0 * rollingAverageRelativeDiff + relativeDiff) / 10.0;
                }
                lastLlp = llp;
                if (reporter.isDebugEnabled()) {
                    Formatter formatter = null;
                    try {
                        try {
                            formatter = new Formatter(Locale.ENGLISH);
                            formatter.format("epoch=%5d lr=%11.9f ll=%11.4f lp=%11.4f llp=%11.4f llp*=%11.4f", epoch, learningRate, ll, lp, llp, bestLlp);
                            reporter.debug(formatter.toString());
                        }
                        catch (IllegalFormatException e) {
                            reporter.warn("Illegal format in discrete chooser");
                            if (formatter != null) {
                                formatter.close();
                            }
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        if (formatter != null) {
                            formatter.close();
                        }
                        throw throwable;
                    }
                    if (formatter != null) {
                        formatter.close();
                    }
                }
            }
            if (rollingAverageRelativeDiff < minImprovement) {
                reporter.info("Converged with rollingAverageRelativeDiff=" + rollingAverageRelativeDiff);
                break;
            }
            ++epoch;
        }
        return chooser;
    }

    static void updatePrior(RegressionPrior prior, Vector coefficientVector, double learningRate) {
        if (prior.isUniform()) {
            return;
        }
        int numDimensions = coefficientVector.numDimensions();
        int d = 0;
        while (d < numDimensions) {
            double priorMode = prior.mode(d);
            double oldVal = coefficientVector.value(d);
            if (oldVal != priorMode) {
                double priorGradient = prior.gradient(oldVal, d);
                double delta = learningRate * priorGradient;
                if (oldVal != 0.0) {
                    double newVal = oldVal > 0.0 ? java.lang.Math.max(0.0, oldVal - delta) : java.lang.Math.min(0.0, oldVal - delta);
                    coefficientVector.setValue(d, newVal);
                }
            }
            ++d;
        }
    }

    static double logLikelihood(DiscreteChooser chooser, Vector[][] alternativess, int[] choices) {
        double ll = 0.0;
        int i = 0;
        while (i < alternativess.length) {
            ll += DiscreteChooser.logLikelihood(chooser, alternativess[i], choices[i]);
            ++i;
        }
        return ll;
    }

    static double logLikelihood(DiscreteChooser chooser, Vector[] alternatives, int choice) {
        double[] logProbs = chooser.choiceLogProbs(alternatives);
        return logProbs[choice];
    }

    static void verifyNonEmpty(Vector[] choices) {
        if (choices.length > 0) {
            return;
        }
        String msg = "Require at least one choice. Found choices.length=0.";
        throw new IllegalArgumentException(msg);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = -8567713287299117186L;
        private final DiscreteChooser mChooser;

        public Externalizer() {
            this(null);
        }

        public Externalizer(DiscreteChooser chooser) {
            this.mChooser = chooser;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mChooser.mCoefficients);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            Vector v = (Vector)in.readObject();
            return new DiscreteChooser(v);
        }
    }
}

