/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class XValidatingObjectCorpus<E>
extends Corpus<ObjectHandler<E>>
implements ObjectHandler<E>,
Serializable {
    static final long serialVersionUID = -4855182679645668642L;
    private final List<E> mItemList;
    private int mNumFolds;
    private int mFold;

    public XValidatingObjectCorpus(int numFolds) {
        this(new ArrayList(), numFolds, 0);
    }

    XValidatingObjectCorpus(List<E> itemList, int numFolds, int fold) {
        this.mItemList = itemList;
        this.setNumFolds(numFolds);
        this.mFold = fold;
    }

    public XValidatingObjectCorpus<E> itemView() {
        return new XValidatingObjectCorpus<E>(Collections.unmodifiableList(this.mItemList), this.mNumFolds, this.mFold);
    }

    public int numFolds() {
        return this.mNumFolds;
    }

    public void setNumFolds(int numFolds) {
        if (numFolds < 0) {
            String msg = "Number of folds must be non-negative. Found numFolds=" + numFolds;
            throw new IllegalArgumentException(msg);
        }
        this.mNumFolds = numFolds;
    }

    public int fold() {
        return this.mFold;
    }

    public void permuteCorpus(Random random) {
        Collections.shuffle(this.mItemList, random);
    }

    public void setFold(int fold) {
        if (this.mNumFolds == 0) {
            String msg = "Cannot set folds when numFolds() is 0.";
            throw new IllegalArgumentException(msg);
        }
        if (fold < 0 || fold >= this.mNumFolds) {
            String msg = "Fold must be non-negative and less than numFolds. Found numFolds=" + this.mNumFolds + " fold=" + fold;
            throw new IllegalArgumentException(msg);
        }
        this.mFold = fold;
    }

    public int size() {
        return this.mItemList.size();
    }

    @Override
    public void handle(E e) {
        this.mItemList.add(e);
    }

    @Override
    public void visitTrain(ObjectHandler<E> handler) {
        this.handle(handler, 0, this.startTestFold());
        this.handle(handler, this.endTestFold(), this.size());
    }

    @Override
    public void visitTest(ObjectHandler<E> handler) {
        this.handle(handler, this.startTestFold(), this.endTestFold());
    }

    @Override
    public void visitCorpus(ObjectHandler<E> handler) {
        for (E e : this.mItemList) {
            handler.handle(e);
        }
    }

    @Override
    public void visitCorpus(ObjectHandler<E> trainHandler, ObjectHandler<E> testHandler) {
        this.visitTrain(trainHandler);
        this.visitTest(testHandler);
    }

    public void visitTest(ObjectHandler<E> handler, int fold) {
        this.handle(handler, this.startTestFold(fold), this.endTestFold(fold));
    }

    public void visitTrain(ObjectHandler<E> handler, int fold) {
        this.handle(handler, 0, this.startTestFold(fold));
        this.handle(handler, this.endTestFold(fold), this.size());
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    private void handle(ObjectHandler<E> handler, int start, int end) {
        int i = start;
        while (i < end) {
            handler.handle(this.mItemList.get(i));
            ++i;
        }
    }

    private int startTestFold() {
        return this.startTestFold(this.mFold);
    }

    private int startTestFold(int fold) {
        if (this.mNumFolds == 0) {
            return 0;
        }
        return (int)((double)this.size() * ((double)fold / (double)this.mNumFolds));
    }

    private int endTestFold() {
        return this.endTestFold(this.mFold);
    }

    private int endTestFold(int fold) {
        if (this.mNumFolds == 0) {
            return 0;
        }
        if (fold == this.mNumFolds - 1) {
            return this.size();
        }
        return (int)((double)this.size() * (((double)fold + 1.0) / (double)this.mNumFolds));
    }

    private static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 5857544240166060800L;
        final XValidatingObjectCorpus<F> mCorpus;

        public Serializer() {
            this(null);
        }

        public Serializer(XValidatingObjectCorpus<F> corpus) {
            this.mCorpus = corpus;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mCorpus.numFolds());
            out.writeInt(this.mCorpus.fold());
            out.writeInt(this.mCorpus.size());
            for (Object f : ((XValidatingObjectCorpus)this.mCorpus).mItemList) {
                out.writeObject(f);
            }
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            int numFolds = in.readInt();
            int fold = in.readInt();
            int size = in.readInt();
            XValidatingObjectCorpus<Object> corpus = new XValidatingObjectCorpus<Object>(numFolds);
            corpus.setFold(fold);
            int i = 0;
            while (i < size) {
                Object o = in.readObject();
                corpus.handle(o);
                ++i;
            }
            return corpus;
        }
    }
}

