/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref.matchers;

import com.aliasi.coref.EnglishMentionFactory;
import com.aliasi.coref.Killer;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import java.util.Collections;
import java.util.Set;

public class HonorificConflictKiller
implements Killer {
    @Override
    public boolean kill(Mention mention, MentionChain chain) {
        Set<String> honorifics1 = mention.honorifics();
        Set<String> honorifics2 = chain.honorifics();
        return honorifics1.size() > 0 && honorifics2.size() > 0 && HonorificConflictKiller.honorificConflict(honorifics1, honorifics2);
    }

    private static boolean honorificConflict(Set<String> honorifics1, Set<String> honorifics2) {
        return HonorificConflictKiller.male(honorifics1) && HonorificConflictKiller.female(honorifics2) || HonorificConflictKiller.female(honorifics1) && HonorificConflictKiller.male(honorifics2);
    }

    private static boolean male(Set<String> honorifics) {
        return !Collections.disjoint(honorifics, EnglishMentionFactory.MALE_HONORIFICS);
    }

    private static boolean female(Set<String> honorifics) {
        return !Collections.disjoint(honorifics, EnglishMentionFactory.FEMALE_HONORIFICS);
    }
}

