/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.Killer;
import com.aliasi.coref.Matcher;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractMentionChain
implements MentionChain {
    private final HashSet<Mention> mMentions = new HashSet();
    String mEntityType;
    final HashSet<String> mHonorifics = new HashSet();
    private int mMaxSentenceOffset;
    String mGender = null;
    private final int mIdentifier;

    public AbstractMentionChain(Mention mention, int offset, int identifier) {
        this.mEntityType = mention.entityType();
        this.mMaxSentenceOffset = offset;
        this.mMentions.add(mention);
        this.mIdentifier = identifier;
        this.mGender = mention.gender();
        this.mHonorifics.addAll(mention.honorifics());
    }

    public void setGender(String gender) {
        this.mGender = gender;
    }

    public void addHonorific(String honorific) {
        this.mHonorifics.add(honorific);
    }

    @Override
    public final Set<Mention> mentions() {
        return this.mMentions;
    }

    @Override
    public final Set<String> honorifics() {
        return this.mHonorifics;
    }

    @Override
    public final String gender() {
        return this.mGender;
    }

    @Override
    public final int maxSentenceOffset() {
        return this.mMaxSentenceOffset;
    }

    @Override
    public String entityType() {
        return this.mEntityType;
    }

    public void setEntityType(String entityType) {
        this.mEntityType = entityType;
    }

    @Override
    public final void add(Mention mention, int sentenceOffset) {
        this.mMentions.add(mention);
        if (sentenceOffset > this.mMaxSentenceOffset) {
            this.mMaxSentenceOffset = sentenceOffset;
        }
        this.add(mention);
    }

    protected void add(Mention mention) {
    }

    @Override
    public final int identifier() {
        return this.mIdentifier;
    }

    @Override
    public final boolean killed(Mention mention) {
        Killer[] killers = this.killers();
        int i = 0;
        while (i < killers.length) {
            if (killers[i].kill(mention, this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final int matchScore(Mention mention) {
        Matcher[] matchers = this.matchers();
        int bestScore = 7;
        int i = 0;
        while (i < matchers.length) {
            int score = matchers[i].match(mention, this);
            if (score != -1 && score < bestScore) {
                bestScore = score;
            }
            ++i;
        }
        return bestScore > 6 ? -1 : bestScore;
    }

    public boolean equals(Object that) {
        return that instanceof MentionChain && this.equals((MentionChain)that);
    }

    public boolean equals(MentionChain that) {
        return this.identifier() == that.identifier();
    }

    public int hashCode() {
        return this.identifier();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID=");
        sb.append(this.identifier());
        sb.append("; mentions=");
        sb.append(this.mentions());
        sb.append("; gender=");
        sb.append(this.gender());
        sb.append("; honorifics=");
        sb.append(this.honorifics());
        sb.append("; maxSentenceOffset=");
        sb.append(this.maxSentenceOffset());
        return sb.toString();
    }

    public abstract Matcher[] matchers();

    public abstract Killer[] killers();
}

