/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.AbstractHierarchicalClusterer;
import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.util.Distance;
import com.aliasi.util.ScoredObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SingleLinkClusterer<E>
extends AbstractHierarchicalClusterer<E> {
    public SingleLinkClusterer(double maxDistance, Distance<? super E> distance) {
        super(maxDistance, distance);
    }

    public SingleLinkClusterer(Distance<? super E> distance) {
        this(Double.POSITIVE_INFINITY, distance);
    }

    @Override
    public Dendrogram<E> hierarchicalCluster(Set<? extends E> elementSet) {
        if (elementSet.size() == 0) {
            String msg = "Require non-empty set to form dendrogram. Found elementSet.size()=" + elementSet.size();
            throw new IllegalArgumentException(msg);
        }
        if (elementSet.size() == 1) {
            return new LeafDendrogram<E>(elementSet.iterator().next());
        }
        E[] elements = this.toElements(elementSet);
        LeafDendrogram[] leafs = new LeafDendrogram[elements.length];
        int i = 0;
        while (i < leafs.length) {
            E elt = elements[i];
            leafs[i] = new LeafDendrogram<E>(elt);
            ++i;
        }
        HashSet<Dendrogram> clusters = new HashSet<Dendrogram>(elements.length);
        LeafDendrogram[] leafDendrogramArray = leafs;
        int n = leafs.length;
        int n2 = 0;
        while (n2 < n) {
            LeafDendrogram dendrogram = leafDendrogramArray[n2];
            clusters.add(dendrogram);
            ++n2;
        }
        ArrayList pairScoreList = new ArrayList();
        int len = elements.length;
        double maxDistance = this.getMaxDistance();
        int i2 = 0;
        while (i2 < len) {
            E eI = elements[i2];
            LeafDendrogram dendroI = leafs[i2];
            int j = i2 + 1;
            while (j < len) {
                E eJ = elements[j];
                double distanceIJ = this.distance().distance(eI, eJ);
                LeafDendrogram dendroJ = leafs[j];
                pairScoreList.add(new AbstractHierarchicalClusterer.PairScore(dendroI, dendroJ, distanceIJ));
                ++j;
            }
            ++i2;
        }
        AbstractHierarchicalClusterer.PairScore[] pairScores = new AbstractHierarchicalClusterer.PairScore[pairScoreList.size()];
        pairScoreList.toArray(pairScores);
        Arrays.sort(pairScores, ScoredObject.comparator());
        int i3 = 0;
        while (i3 < pairScores.length && clusters.size() > 1) {
            Dendrogram d2;
            AbstractHierarchicalClusterer.PairScore ps = pairScores[i3];
            if (ps.score() > this.getMaxDistance()) break;
            Dendrogram d1 = ps.mDendrogram1.dereference();
            if (!d1.equals(d2 = ps.mDendrogram2.dereference())) {
                clusters.remove(d1);
                clusters.remove(d2);
                LinkDendrogram dLink = new LinkDendrogram(d1, d2, pairScores[i3].mScore);
                clusters.add(dLink);
            }
            ++i3;
        }
        Iterator it = clusters.iterator();
        LinkDendrogram dendro = (LinkDendrogram)it.next();
        while (it.hasNext()) {
            dendro = new LinkDendrogram(dendro, (Dendrogram)it.next(), Double.POSITIVE_INFINITY);
        }
        return dendro;
    }
}

