/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.cluster;

import com.aliasi.cluster.Dendrogram;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Distance;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class LinkDendrogram<E>
extends Dendrogram<E> {
    private final double mCost;
    private final Dendrogram<E> mDendrogram1;
    private final Dendrogram<E> mDendrogram2;

    public LinkDendrogram(Dendrogram<E> dendrogram1, Dendrogram<E> dendrogram2, double cost) {
        if (cost < 0.0 || Double.isNaN(cost)) {
            String msg = "Cost must be >= 0.0 Found cost=" + cost;
            throw new IllegalArgumentException(msg);
        }
        dendrogram1.setParent(this);
        dendrogram2.setParent(this);
        this.mDendrogram1 = dendrogram1;
        this.mDendrogram2 = dendrogram2;
        this.mCost = cost;
    }

    @Override
    public double score() {
        return this.mCost;
    }

    @Override
    public Set<E> memberSet() {
        HashSet members = new HashSet();
        this.addMembers(members);
        return members;
    }

    @Override
    void addMembers(Set<E> set) {
        this.mDendrogram1.addMembers(set);
        this.mDendrogram2.addMembers(set);
    }

    @Override
    void split(Collection<Set<E>> resultSet, BoundedPriorityQueue<Dendrogram<E>> queue) {
        queue.offer(this.mDendrogram1);
        queue.offer(this.mDendrogram2);
    }

    public Dendrogram<E> dendrogram1() {
        return this.mDendrogram1;
    }

    public Dendrogram<E> dendrogram2() {
        return this.mDendrogram2;
    }

    @Override
    void subpartitionDistance(LinkedList<Dendrogram<E>> stack) {
        stack.addFirst(this.dendrogram1());
        stack.addFirst(this.dendrogram2());
    }

    @Override
    int copheneticCorrelation(int i, double[] xs, double[] ys, Distance<? super E> distance) {
        for (E e1 : this.mDendrogram1.memberSet()) {
            for (E e2 : this.mDendrogram2.memberSet()) {
                xs[i] = this.score();
                ys[i] = distance.distance(e1, e2);
                ++i;
            }
        }
        return i;
    }

    @Override
    void toString(StringBuilder sb, int depth) {
        sb.append('{');
        this.mDendrogram1.toString(sb, depth + 1);
        sb.append('+');
        this.mDendrogram2.toString(sb, depth + 1);
        sb.append("}:");
        sb.append(this.mCost);
    }

    @Override
    void prettyPrint(StringBuilder sb, int depth) {
        this.indent(sb, depth);
        sb.append(this.score());
        this.mDendrogram1.prettyPrint(sb, depth + 1);
        this.mDendrogram2.prettyPrint(sb, depth + 1);
    }
}

