/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.RankedClassifierEvaluator;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import com.aliasi.util.Scored;
import java.util.ArrayList;
import java.util.List;

public class ScoredClassifierEvaluator<E>
extends RankedClassifierEvaluator<E> {
    private final List<ScoreOutcome>[] mScoreOutcomeLists;
    boolean mDefectiveScoring = false;

    public ScoredClassifierEvaluator(ScoredClassifier<E> classifier, String[] categories, boolean storeInputs) {
        super(classifier, categories, storeInputs);
        ArrayList[] scoreOutcomeLists = new ArrayList[this.numCategories()];
        this.mScoreOutcomeLists = scoreOutcomeLists;
        int i = 0;
        while (i < this.mScoreOutcomeLists.length) {
            this.mScoreOutcomeLists[i] = new ArrayList<ScoreOutcome>();
            ++i;
        }
    }

    @Override
    public void setClassifier(ScoredClassifier<E> classifier) {
        this.setClassifier(classifier, ScoredClassifierEvaluator.class);
    }

    @Override
    public ScoredClassifier<E> classifier() {
        ScoredClassifier result = (ScoredClassifier)super.classifier();
        return result;
    }

    @Override
    public void handle(Classified<E> classified) {
        E input = classified.getObject();
        Classification refClassification = classified.getClassification();
        String refCategory = refClassification.bestCategory();
        this.validateCategory(refCategory);
        ScoredClassification classification = this.classifier().classify(input);
        this.addClassification(refCategory, classification, input);
        this.addRanking(refCategory, classification);
        this.addScoring(refCategory, classification);
    }

    public ScoredPrecisionRecallEvaluation scoredOneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        return this.scoredOneVersusAll(this.mScoreOutcomeLists, this.categoryToIndex(refCategory));
    }

    public double averageScore(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.mReferenceCategories.size()) {
            if (((String)this.mReferenceCategories.get(i)).equals(refCategory)) {
                ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
                int rank = 0;
                while (rank < c.size()) {
                    if (c.category(rank).equals(responseCategory)) {
                        sum += c.score(rank);
                        ++count;
                        break;
                    }
                    ++rank;
                }
            }
            ++i;
        }
        return sum / (double)count;
    }

    public double averageScoreReference() {
        double sum = 0.0;
        int i = 0;
        while (i < this.mReferenceCategories.size()) {
            String refCategory = ((String)this.mReferenceCategories.get(i)).toString();
            ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
            int rank = 0;
            while (rank < c.size()) {
                if (c.category(rank).equals(refCategory)) {
                    sum += c.score(rank);
                    break;
                }
                ++rank;
            }
            ++i;
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    ScoredPrecisionRecallEvaluation scoredOneVersusAll(List<ScoreOutcome>[] outcomeLists, int categoryIndex) {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        for (ScoreOutcome outcome : outcomeLists[categoryIndex]) {
            eval.addCase(outcome.mOutcome, outcome.mScore);
        }
        return eval;
    }

    void addScoring(String refCategory, ScoredClassification scoring) {
        if (scoring.size() < this.numCategories()) {
            this.mDefectiveScoring = true;
        }
        int rank = 0;
        while (rank < this.numCategories() && rank < scoring.size()) {
            double score = scoring.score(rank);
            String category = scoring.category(rank);
            int categoryIndex = this.categoryToIndex(category);
            boolean match = category.equals(refCategory);
            ScoreOutcome outcome = new ScoreOutcome(score, match, rank == 0);
            this.mScoreOutcomeLists[categoryIndex].add(outcome);
            ++rank;
        }
    }

    @Override
    void baseToString(StringBuilder sb) {
        super.baseToString(sb);
        sb.append("Average Score Reference=" + this.averageScoreReference() + "\n");
    }

    @Override
    void oneVsAllToString(StringBuilder sb, String category, int i) {
        super.oneVsAllToString(sb, category, i);
        sb.append("Scored One Versus All\n");
        sb.append(this.scoredOneVersusAll(category) + "\n");
        sb.append("Average Score Histogram=\n");
        this.appendCategoryLine(sb);
        int j = 0;
        while (j < this.numCategories()) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this.averageScore(category, this.categories()[j]));
            ++j;
        }
        sb.append("\n");
    }

    static class ScoreOutcome
    implements Scored {
        private final double mScore;
        private final boolean mOutcome;
        private final boolean mFirstBest;

        public ScoreOutcome(double score, boolean outcome, boolean firstBest) {
            this.mOutcome = outcome;
            this.mScore = score;
            this.mFirstBest = firstBest;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public String toString() {
            return "(" + this.mScore + ": " + this.mOutcome + "firstBest=" + this.mFirstBest + ")";
        }
    }
}

