/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.stats.Statistics;
import com.aliasi.util.Math;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConfusionMatrix {
    private final String[] mCategories;
    private final int[][] mMatrix;
    private final Map<String, Integer> mCategoryToIndex = new HashMap<String, Integer>();

    public ConfusionMatrix(String[] categories) {
        this.mCategories = (String[])categories.clone();
        int len = categories.length;
        this.mMatrix = new int[len][len];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                this.mMatrix[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < len) {
            this.mCategoryToIndex.put(categories[i], i);
            ++i;
        }
    }

    public ConfusionMatrix(String[] categories, int[][] matrix) {
        this.mCategories = categories;
        this.mMatrix = matrix;
        if (categories.length != matrix.length) {
            String msg = "Categories and matrix must be of same length. Found categories length=" + categories.length + " and matrix length=" + matrix.length;
            throw new IllegalArgumentException(msg);
        }
        int j = 0;
        while (j < matrix.length) {
            if (categories.length != matrix[j].length) {
                String msg = "Categories and all matrix rows must be of same length. Found categories length=" + categories.length + " Found row " + j + " length=" + matrix[j].length;
                throw new IllegalArgumentException(msg);
            }
            ++j;
        }
        int len = matrix.length;
        int i = 0;
        while (i < len) {
            int j2 = 0;
            while (j2 < len) {
                if (matrix[i][j2] < 0) {
                    String msg = "Matrix entries must be non-negative. matrix[" + i + "][" + j2 + "]=" + matrix[i][j2];
                    throw new IllegalArgumentException(msg);
                }
                ++j2;
            }
            ++i;
        }
    }

    public String[] categories() {
        return (String[])this.mCategories.clone();
    }

    public int numCategories() {
        return this.categories().length;
    }

    public int getIndex(String category) {
        Integer index = this.mCategoryToIndex.get(category);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int[][] matrix() {
        return (int[][])this.mMatrix.clone();
    }

    public void increment(int referenceCategoryIndex, int responseCategoryIndex) {
        this.checkIndex("reference", referenceCategoryIndex);
        this.checkIndex("response", responseCategoryIndex);
        int[] nArray = this.mMatrix[referenceCategoryIndex];
        int n = responseCategoryIndex;
        nArray[n] = nArray[n] + 1;
    }

    public void incrementByN(int referenceCategoryIndex, int responseCategoryIndex, int num) {
        this.checkIndex("reference", referenceCategoryIndex);
        this.checkIndex("response", responseCategoryIndex);
        if (this.mMatrix[referenceCategoryIndex][responseCategoryIndex] + num < 0) {
            String msg = "Cannot decrement to less than 0 value. referenceCategoryIndex=" + referenceCategoryIndex + " responseCategoryIndex=" + responseCategoryIndex + " matrix[referenceCategoryIndex][responseCategoryIndex]=" + this.mMatrix[referenceCategoryIndex][referenceCategoryIndex] + " increment=" + num;
            throw new IllegalArgumentException(msg);
        }
        int[] nArray = this.mMatrix[referenceCategoryIndex];
        int n = responseCategoryIndex;
        nArray[n] = nArray[n] + num;
    }

    public void increment(String referenceCategory, String responseCategory) {
        this.increment(this.getIndex(referenceCategory), this.getIndex(responseCategory));
    }

    public int count(int referenceCategoryIndex, int responseCategoryIndex) {
        this.checkIndex("reference", referenceCategoryIndex);
        this.checkIndex("response", responseCategoryIndex);
        return this.mMatrix[referenceCategoryIndex][responseCategoryIndex];
    }

    public int totalCount() {
        int total = 0;
        int len = this.numCategories();
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                total += this.mMatrix[i][j];
                ++j;
            }
            ++i;
        }
        return total;
    }

    public int totalCorrect() {
        int total = 0;
        int len = this.numCategories();
        int i = 0;
        while (i < len) {
            total += this.mMatrix[i][i];
            ++i;
        }
        return total;
    }

    public double totalAccuracy() {
        return (double)this.totalCorrect() / (double)this.totalCount();
    }

    public double confidence95() {
        return this.confidence(1.96);
    }

    public double confidence99() {
        return this.confidence(2.58);
    }

    public double confidence(double z) {
        double p = this.totalAccuracy();
        double n = this.totalCount();
        return z * java.lang.Math.sqrt(p * (1.0 - p) / n);
    }

    public double referenceEntropy() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            double prob = this.oneVsAll(i).referenceLikelihood();
            sum += prob * Math.log2(prob);
            ++i;
        }
        return -sum;
    }

    public double responseEntropy() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            double prob = this.oneVsAll(i).responseLikelihood();
            sum += prob * Math.log2(prob);
            ++i;
        }
        return -sum;
    }

    public double crossEntropy() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            PrecisionRecallEvaluation eval = this.oneVsAll(i);
            double referenceProb = eval.referenceLikelihood();
            double responseProb = eval.responseLikelihood();
            sum += referenceProb * Math.log2(responseProb);
            ++i;
        }
        return -sum;
    }

    public double jointEntropy() {
        double totalCount = this.totalCount();
        double entropySum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            int j = 0;
            while (j < this.numCategories()) {
                double prob = (double)this.count(i, j) / totalCount;
                if (!(prob <= 0.0)) {
                    entropySum += prob * Math.log2(prob);
                }
                ++j;
            }
            ++i;
        }
        return -entropySum;
    }

    public double conditionalEntropy(int refCategoryIndex) {
        double entropySum = 0.0;
        long refCount = this.oneVsAll(refCategoryIndex).positiveReference();
        int j = 0;
        while (j < this.numCategories()) {
            double conditionalProb = (double)this.count(refCategoryIndex, j) / (double)refCount;
            if (!(conditionalProb <= 0.0)) {
                entropySum += conditionalProb * Math.log2(conditionalProb);
            }
            ++j;
        }
        return -entropySum;
    }

    public double conditionalEntropy() {
        double entropySum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            double refProbI = this.oneVsAll(i).referenceLikelihood();
            entropySum += refProbI * this.conditionalEntropy(i);
            ++i;
        }
        return entropySum;
    }

    public double kappa() {
        return this.kappa(this.randomAccuracy());
    }

    public double kappaUnbiased() {
        return this.kappa(this.randomAccuracyUnbiased());
    }

    public double kappaNoPrevalence() {
        return 2.0 * this.totalAccuracy() - 1.0;
    }

    private double kappa(double PE) {
        double PA = this.totalAccuracy();
        return (PA - PE) / (1.0 - PE);
    }

    public double randomAccuracy() {
        double randomAccuracy = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            PrecisionRecallEvaluation eval = this.oneVsAll(i);
            randomAccuracy += eval.referenceLikelihood() * eval.responseLikelihood();
            ++i;
        }
        return randomAccuracy;
    }

    public double randomAccuracyUnbiased() {
        double randomAccuracy = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            PrecisionRecallEvaluation eval = this.oneVsAll(i);
            double avgLikelihood = (eval.referenceLikelihood() + eval.responseLikelihood()) / 2.0;
            randomAccuracy += avgLikelihood * avgLikelihood;
            ++i;
        }
        return randomAccuracy;
    }

    public int chiSquaredDegreesOfFreedom() {
        int sqrt = this.numCategories() - 1;
        return sqrt * sqrt;
    }

    public double chiSquared() {
        int numCategories = this.numCategories();
        double[][] contingencyMatrix = new double[numCategories][numCategories];
        int i = 0;
        while (i < numCategories) {
            int j = 0;
            while (j < numCategories) {
                contingencyMatrix[i][j] = this.count(i, j);
                ++j;
            }
            ++i;
        }
        return Statistics.chiSquaredIndependence(contingencyMatrix);
    }

    public double phiSquared() {
        return this.chiSquared() / (double)this.totalCount();
    }

    public double cramersV() {
        double LMinusOne = this.numCategories() - 1;
        return java.lang.Math.sqrt(this.phiSquared() / LMinusOne);
    }

    public PrecisionRecallEvaluation oneVsAll(int categoryIndex) {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        int i = 0;
        while (i < this.numCategories()) {
            int j = 0;
            while (j < this.numCategories()) {
                eval.addCase(i == categoryIndex, j == categoryIndex, this.mMatrix[i][j]);
                ++j;
            }
            ++i;
        }
        return eval;
    }

    public PrecisionRecallEvaluation microAverage() {
        long tp = 0L;
        long fp = 0L;
        long fn = 0L;
        long tn = 0L;
        int i = 0;
        while (i < this.numCategories()) {
            PrecisionRecallEvaluation eval = this.oneVsAll(i);
            tp += eval.truePositive();
            fp += eval.falsePositive();
            tn += eval.trueNegative();
            fn += eval.falseNegative();
            ++i;
        }
        return new PrecisionRecallEvaluation(tp, fn, fp, tn);
    }

    public double macroAvgPrecision() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            sum += this.oneVsAll(i).precision();
            ++i;
        }
        return sum / (double)this.numCategories();
    }

    public double macroAvgRecall() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            sum += this.oneVsAll(i).recall();
            ++i;
        }
        return sum / (double)this.numCategories();
    }

    public double macroAvgFMeasure() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            sum += this.oneVsAll(i).fMeasure();
            ++i;
        }
        return sum / (double)this.numCategories();
    }

    public double lambdaA() {
        double maxReferenceCount = 0.0;
        int j = 0;
        while (j < this.numCategories()) {
            double referenceCount = this.oneVsAll(j).positiveReference();
            if (referenceCount > maxReferenceCount) {
                maxReferenceCount = referenceCount;
            }
            ++j;
        }
        double maxCountSum = 0.0;
        int j2 = 0;
        while (j2 < this.numCategories()) {
            int maxCount = 0;
            int i = 0;
            while (i < this.numCategories()) {
                int count = this.count(i, j2);
                if (count > maxCount) {
                    maxCount = count;
                }
                ++i;
            }
            maxCountSum += (double)maxCount;
            ++j2;
        }
        double totalCount = this.totalCount();
        return (maxCountSum - maxReferenceCount) / (totalCount - maxReferenceCount);
    }

    public double lambdaB() {
        double maxResponseCount = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            double responseCount = this.oneVsAll(i).positiveResponse();
            if (responseCount > maxResponseCount) {
                maxResponseCount = responseCount;
            }
            ++i;
        }
        double maxCountSum = 0.0;
        int i2 = 0;
        while (i2 < this.numCategories()) {
            int maxCount = 0;
            int j = 0;
            while (j < this.numCategories()) {
                int count = this.count(i2, j);
                if (count > maxCount) {
                    maxCount = count;
                }
                ++j;
            }
            maxCountSum += (double)maxCount;
            ++i2;
        }
        double totalCount = this.totalCount();
        return (maxCountSum - maxResponseCount) / (totalCount - maxResponseCount);
    }

    public double mutualInformation() {
        double totalCount = this.totalCount();
        double sum = 0.0;
        int i = 0;
        while (i < this.numCategories()) {
            double pI = this.oneVsAll(i).referenceLikelihood();
            if (!(pI <= 0.0)) {
                int j = 0;
                while (j < this.numCategories()) {
                    double pIJ;
                    double pJ = this.oneVsAll(j).responseLikelihood();
                    if (!(pJ <= 0.0) && !((pIJ = (double)this.count(i, j) / totalCount) <= 0.0)) {
                        sum += pIJ * Math.log2(pIJ / (pI * pJ));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sum;
    }

    public double klDivergence() {
        double sum = 0.0;
        int k = 0;
        while (k < this.numCategories()) {
            PrecisionRecallEvaluation eval = this.oneVsAll(k);
            double refProb = eval.referenceLikelihood();
            double responseProb = eval.responseLikelihood();
            sum += refProb * Math.log2(refProb / responseProb);
            ++k;
        }
        return sum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GLOBAL CONFUSION MATRIX STATISTICS\n");
        this.toStringGlobal(sb);
        int i = 0;
        while (i < this.numCategories()) {
            sb.append("CATEGORY " + i + "=" + this.categories()[i] + " VS. ALL\n");
            sb.append("  Conditional Entropy=" + this.conditionalEntropy(i));
            sb.append('\n');
            sb.append(this.oneVsAll(i).toString());
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    void toStringGlobal(StringBuilder sb) {
        String[] categories = this.categories();
        sb.append("Categories=" + Arrays.asList(categories));
        sb.append('\n');
        sb.append("Total Count=" + this.totalCount());
        sb.append('\n');
        sb.append("Total Correct=" + this.totalCorrect());
        sb.append('\n');
        sb.append("Total Accuracy=" + this.totalAccuracy());
        sb.append('\n');
        sb.append("95% Confidence Interval=" + this.totalAccuracy() + " +/- " + this.confidence95());
        sb.append('\n');
        sb.append("Confusion Matrix\n");
        sb.append("reference \\ response\n");
        sb.append(this.matrixToCSV());
        sb.append('\n');
        sb.append("Macro-averaged Precision=" + this.macroAvgPrecision());
        sb.append('\n');
        sb.append("Macro-averaged Recall=" + this.macroAvgRecall());
        sb.append('\n');
        sb.append("Macro-averaged F=" + this.macroAvgFMeasure());
        sb.append('\n');
        sb.append("Micro-averaged Results\n");
        sb.append("         the following symmetries are expected:\n");
        sb.append("           TP=TN, FN=FP\n");
        sb.append("           PosRef=PosResp=NegRef=NegResp\n");
        sb.append("           Acc=Prec=Rec=F\n");
        sb.append(this.microAverage().toString());
        sb.append('\n');
        sb.append("Random Accuracy=" + this.randomAccuracy());
        sb.append('\n');
        sb.append("Random Accuracy Unbiased=" + this.randomAccuracyUnbiased());
        sb.append('\n');
        sb.append("kappa=" + this.kappa());
        sb.append('\n');
        sb.append("kappa Unbiased=" + this.kappaUnbiased());
        sb.append('\n');
        sb.append("kappa No Prevalence =" + this.kappaNoPrevalence());
        sb.append('\n');
        sb.append("Reference Entropy=" + this.referenceEntropy());
        sb.append('\n');
        sb.append("Response Entropy=" + this.responseEntropy());
        sb.append('\n');
        sb.append("Cross Entropy=" + this.crossEntropy());
        sb.append('\n');
        sb.append("Joint Entropy=" + this.jointEntropy());
        sb.append('\n');
        sb.append("Conditional Entropy=" + this.conditionalEntropy());
        sb.append('\n');
        sb.append("Mutual Information=" + this.mutualInformation());
        sb.append('\n');
        sb.append("Kullback-Liebler Divergence=" + this.klDivergence());
        sb.append('\n');
        sb.append("chi Squared=" + this.chiSquared());
        sb.append('\n');
        sb.append("chi-Squared Degrees of Freedom=" + this.chiSquaredDegreesOfFreedom());
        sb.append('\n');
        sb.append("phi Squared=" + this.phiSquared());
        sb.append('\n');
        sb.append("Cramer's V=" + this.cramersV());
        sb.append('\n');
        sb.append("lambda A=" + this.lambdaA());
        sb.append('\n');
        sb.append("lambda B=" + this.lambdaB());
        sb.append('\n');
    }

    String matrixToCSV() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        int i = 0;
        while (i < this.numCategories()) {
            sb.append(',');
            sb.append(this.categories()[i]);
            ++i;
        }
        i = 0;
        while (i < this.numCategories()) {
            sb.append("\n  ");
            sb.append(this.categories()[i]);
            int j = 0;
            while (j < this.numCategories()) {
                sb.append(',');
                sb.append(this.count(i, j));
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    String matrixToHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<table border='1' cellpadding='5'>");
        sb.append('\n');
        sb.append("<tr>\n  <td colspan='2' rowspan='2'>&nbsp;</td>");
        sb.append("\n  <td colspan='" + this.numCategories() + "' align='center' bgcolor='darkgray'><b>Response</b></td></tr>");
        sb.append("<tr>");
        int i = 0;
        while (i < this.numCategories()) {
            sb.append("\n  <td align='right' bgcolor='lightgray'><i>" + this.categories()[i] + "</i></td>");
            ++i;
        }
        sb.append("</tr>\n");
        i = 0;
        while (i < this.numCategories()) {
            sb.append("<tr>");
            if (i == 0) {
                sb.append("\n  <td rowspan='" + this.numCategories() + "' bgcolor='darkgray'><b>Ref-<br>erence</b></td>");
            }
            sb.append("\n  <td align='right' bgcolor='lightgray'><i>" + this.categories()[i] + "</i></td>");
            int j = 0;
            while (j < this.numCategories()) {
                if (i == j) {
                    sb.append("\n  <td align='right' bgcolor='lightgreen'>");
                } else if (this.count(i, j) == 0) {
                    sb.append("\n  <td align='right' bgcolor='yellow'>");
                } else {
                    sb.append("\n  <td align='right' bgcolor='red'>");
                }
                sb.append(this.count(i, j));
                sb.append("</td>");
                ++j;
            }
            sb.append("</tr>\n");
            ++i;
        }
        sb.append("</table>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    private void checkIndex(String argMsg, int index) {
        if (index < 0) {
            String msg = "Index for " + argMsg + " must be > 0." + " Found index=" + index;
            throw new IllegalArgumentException(msg);
        }
        if (index >= this.numCategories()) {
            String msg = "Index for " + argMsg + " must be < numCategories()=" + this.numCategories();
            throw new IllegalArgumentException(msg);
        }
    }
}

