/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.corpus.ObjectHandler;
import java.util.Arrays;

class ChunkTagHandlerAdapter2 {
    private ObjectHandler<Chunking> mChunkHandler;
    public static String OUT_TAG = "O";
    public static String BEGIN_TAG_PREFIX = "B-";
    public static String IN_TAG_PREFIX = "I-";

    public ChunkTagHandlerAdapter2() {
    }

    public ChunkTagHandlerAdapter2(ObjectHandler<Chunking> handler) {
        this.mChunkHandler = handler;
    }

    public void setChunkHandler(ObjectHandler<Chunking> handler) {
        this.mChunkHandler = handler;
    }

    public void handle(String[] tokens, String[] whitespaces, String[] tags) {
        if (tokens.length != tags.length) {
            String msg = "Tags and tokens must be same length. Found tokens.length=" + tokens.length + " tags.length=" + tags.length;
            throw new IllegalArgumentException(msg);
        }
        if (whitespaces != null && whitespaces.length != 1 + tokens.length) {
            String msg = "Whitespaces must be one longer than tokens. Found tokens.length=" + tokens.length + " whitespaces.length=" + whitespaces.length;
            throw new IllegalArgumentException(msg);
        }
        Chunking chunking = ChunkTagHandlerAdapter2.toChunkingBIO(tokens, whitespaces, tags);
        this.mChunkHandler.handle(chunking);
    }

    public static String toBaseTag(String tag) {
        if (ChunkTagHandlerAdapter2.isBeginTag(tag) || ChunkTagHandlerAdapter2.isInTag(tag)) {
            return tag.substring(2);
        }
        String msg = "Tag is neither begin not continuation tag. Tag=" + tag;
        throw new IllegalArgumentException(msg);
    }

    public static boolean isBeginTag(String tag) {
        return tag.startsWith(BEGIN_TAG_PREFIX);
    }

    public static boolean isOutTag(String tag) {
        return tag.equals(OUT_TAG);
    }

    public static boolean isInTag(String tag) {
        return tag.startsWith(IN_TAG_PREFIX);
    }

    public static String toInTag(String type) {
        return String.valueOf(IN_TAG_PREFIX) + type;
    }

    public static String toBeginTag(String type) {
        return String.valueOf(BEGIN_TAG_PREFIX) + type;
    }

    public static Chunking toChunkingBIO(String[] tokens, String[] whitespaces, String[] tags) {
        StringBuilder sb = new StringBuilder();
        if (whitespaces == null) {
            whitespaces = new String[tokens.length + 1];
            Arrays.fill(whitespaces, " ");
            whitespaces[0] = "";
            whitespaces[whitespaces.length - 1] = "";
        }
        int i = 0;
        while (i < tokens.length) {
            sb.append(whitespaces[i]);
            sb.append(tokens[i]);
            ++i;
        }
        sb.append(whitespaces[whitespaces.length - 1]);
        ChunkingImpl chunking = new ChunkingImpl(sb);
        int pos = 0;
        int i2 = 0;
        block1: while (i2 < tokens.length) {
            pos += whitespaces[i2].length();
            if (!ChunkTagHandlerAdapter2.isBeginTag(tags[i2])) {
                pos += tokens[i2].length();
                ++i2;
                continue;
            }
            int start = pos;
            String type = ChunkTagHandlerAdapter2.toBaseTag(tags[i2]);
            while (true) {
                pos += tokens[i2].length();
                if (++i2 >= tokens.length || !ChunkTagHandlerAdapter2.isInTag(tags[i2])) {
                    chunking.add(ChunkFactory.createChunk(start, pos, type));
                    continue block1;
                }
                pos += whitespaces[i2].length();
            }
        }
        return chunking;
    }
}

