/*
 * Decompiled with CFR 0.152.
 */
package abner;

import abner.Scanner;
import edu.umass.cs.mallet.base.fst.CRF4;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.iterator.LineGroupIterator;
import edu.umass.cs.mallet.base.pipe.iterator.PipeInputIterator;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.InstanceList;
import edu.umass.cs.mallet.base.types.Sequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Pattern;

public class Tagger {
    public static final int NLPBA = 0;
    public static final int BIOCREATIVE = 1;
    public static final int EXTERNAL = 2;
    private CRF4 myCRF;
    private Pipe myPipe;
    private boolean doTokenization = true;
    private int myMode;

    private void initialize(ObjectInputStream ois) throws Exception {
        this.myCRF = (CRF4)ois.readObject();
        this.myPipe = this.myCRF.getInputPipe();
    }

    public Tagger() {
        this(0);
    }

    public Tagger(int mode) {
        try {
            this.myMode = mode;
            URL model = null;
            if (mode == 1) {
                System.err.println("Loading BioCreative tagging module...");
                model = Tagger.class.getResource("resources/biocreative.crf");
            } else {
                System.err.println("Loading default NLPBA tagging module...");
                model = Tagger.class.getResource("resources/nlpba.crf");
            }
            ObjectInputStream ois = new ObjectInputStream(model.openStream());
            this.initialize(ois);
            ois.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public Tagger(File f) {
        try {
            System.err.println("Loading external tagging module from '" + f.getPath() + "'...");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            this.initialize(ois);
            ois.close();
            this.myMode = 2;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void setTokenization(boolean t) {
        this.doTokenization = t;
    }

    public boolean getTokenization() {
        return this.doTokenization;
    }

    public int getMode() {
        return this.myMode;
    }

    public String tokenize(String s) {
        StringBuffer sb = new StringBuffer();
        try {
            String t;
            Scanner scanner = new Scanner(new StringReader(s));
            while ((t = scanner.nextToken()) != null) {
                sb.append(t + " ");
                if (!t.toString().matches("[?!\\.]")) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            System.err.println(e);
            return sb.toString();
        }
    }

    public Vector getWords(String text) {
        Vector<String[][]> myList = new Vector<String[][]>();
        Vector tagged = this.doTheTagging(text);
        for (int i = 0; i < tagged.size(); ++i) {
            myList.add((String[][])tagged.get(i));
        }
        return myList;
    }

    public Vector getSegments(String text) {
        Vector<String[][]> myList = new Vector<String[][]>();
        Vector tagged = this.doTheTagging(text);
        for (int i = 0; i < tagged.size(); ++i) {
            String[][] sent = (String[][])tagged.get(i);
            if (sent[0].length > 0) {
                Vector<String> tmpSegs = new Vector<String>();
                Vector<String> tmpTags = new Vector<String>();
                StringBuffer tmpSeg = new StringBuffer(sent[0][0]);
                String tmpTag = sent[1][0].replaceAll("[BI]-", "");
                for (int j = 1; j < sent[0].length; ++j) {
                    if (!sent[1][j].replaceAll("[BI]-", "").equals(tmpTag)) {
                        tmpSegs.add(tmpSeg.toString());
                        tmpTags.add(tmpTag);
                        tmpSeg = new StringBuffer(sent[0][j]);
                        tmpTag = sent[1][j].replaceAll("[BI]-", "");
                        continue;
                    }
                    tmpSeg.append(" " + sent[0][j]);
                }
                tmpSegs.add(tmpSeg.toString());
                tmpTags.add(tmpTag);
                String[][] val = new String[2][tmpSegs.size()];
                for (int j = 0; j < val[0].length; ++j) {
                    val[0][j] = (String)tmpSegs.get(j);
                    val[1][j] = (String)tmpTags.get(j);
                }
                myList.add(val);
                continue;
            }
            myList.add(new String[2][0]);
        }
        return myList;
    }

    public String[][] getEntities(String text) {
        Vector<String> tmpSegs = new Vector<String>();
        Vector<String> tmpTags = new Vector<String>();
        Vector tagged = this.doTheTagging(text);
        for (int i = 0; i < tagged.size(); ++i) {
            String[][] sent = (String[][])tagged.get(i);
            if (sent[0].length <= 0) continue;
            StringBuffer tmpSeg = new StringBuffer(sent[0][0]);
            String tmpTag = sent[1][0].replaceAll("[BI]-", "");
            for (int j = 1; j < sent[0].length; ++j) {
                if (!sent[1][j].replaceAll("[BI]-", "").equals(tmpTag)) {
                    if (!tmpTag.equals("O")) {
                        tmpSegs.add(tmpSeg.toString());
                        tmpTags.add(tmpTag);
                    }
                    tmpSeg = new StringBuffer(sent[0][j]);
                    tmpTag = sent[1][j].replaceAll("[BI]-", "");
                    continue;
                }
                tmpSeg.append(" " + sent[0][j]);
            }
            if (tmpTag.equals("O")) continue;
            tmpSegs.add(tmpSeg.toString());
            tmpTags.add(tmpTag);
        }
        String[][] result = new String[2][tmpSegs.size()];
        for (int j = 0; j < result[0].length; ++j) {
            result[0][j] = (String)tmpSegs.get(j);
            result[1][j] = (String)tmpTags.get(j);
        }
        return result;
    }

    public String[] getEntities(String text, String tag) {
        Vector<String> tmpSegs = new Vector<String>();
        Vector<String> tmpTags = new Vector<String>();
        Vector tagged = this.doTheTagging(text);
        for (int i = 0; i < tagged.size(); ++i) {
            String[][] sent = (String[][])tagged.get(i);
            if (sent[0].length <= 0) continue;
            StringBuffer tmpSeg = new StringBuffer(sent[0][0]);
            String tmpTag = sent[1][0].replaceAll("[BI]-", "");
            for (int j = 1; j < sent[0].length; ++j) {
                if (!sent[1][j].replaceAll("[BI]-", "").equals(tmpTag)) {
                    if (tmpTag.equals(tag)) {
                        tmpSegs.add(tmpSeg.toString());
                        tmpTags.add(tmpTag);
                    }
                    tmpSeg = new StringBuffer(sent[0][j]);
                    tmpTag = sent[1][j].replaceAll("[BI]-", "");
                    continue;
                }
                tmpSeg.append(" " + sent[0][j]);
            }
            if (!tmpTag.equals(tag)) continue;
            tmpSegs.add(tmpSeg.toString());
            tmpTags.add(tmpTag);
        }
        String[] result = new String[tmpSegs.size()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = (String)tmpSegs.get(j);
        }
        return result;
    }

    public String tagABNER(String text) {
        StringBuffer tmp = new StringBuffer();
        Vector tagged = this.doTheTagging(text);
        for (int i = 0; i < tagged.size(); ++i) {
            String[][] sent = (String[][])tagged.get(i);
            for (int j = 0; j < sent[0].length; ++j) {
                tmp.append(sent[0][j] + "|");
                tmp.append(sent[1][j] + "  ");
            }
            if (sent[0].length <= 0) continue;
            tmp.append("\n");
        }
        return tmp.toString();
    }

    public String tagIOB(String text) {
        StringBuffer tmp = new StringBuffer();
        Vector tagged = this.doTheTagging(text);
        String tag = "";
        for (int i = 0; i < tagged.size(); ++i) {
            String[][] sent = (String[][])tagged.get(i);
            for (int j = 0; j < sent[0].length; ++j) {
                tmp.append(sent[0][j] + "\t");
                tmp.append(sent[1][j] + "\n");
            }
            if (sent[0].length <= 0) continue;
            tmp.append("\n");
        }
        return tmp.toString();
    }

    public String tagSGML(String text) {
        StringBuffer tmp = new StringBuffer();
        Vector segs = this.getSegments(text);
        for (int i = 0; i < segs.size(); ++i) {
            String[][] s = (String[][])segs.get(i);
            for (int j = 0; j < s[0].length; ++j) {
                if (s[1][j].equals("O")) {
                    tmp.append(s[0][j] + " ");
                    continue;
                }
                tmp.append("<" + s[1][j] + "> " + s[0][j] + " </" + s[1][j] + "> ");
            }
            tmp.append("\n");
        }
        return tmp.toString();
    }

    private Vector doTheTagging(String text) {
        Vector<String[][]> result = new Vector<String[][]>();
        InstanceList data = new InstanceList(this.myPipe);
        if (this.doTokenization) {
            data.add((PipeInputIterator)new LineGroupIterator((Reader)new StringReader(this.tokenize(text)), Pattern.compile("^.*$"), false));
        } else {
            data.add((PipeInputIterator)new LineGroupIterator((Reader)new StringReader(text), Pattern.compile("^.*$"), false));
        }
        for (int i = 0; i < data.size(); ++i) {
            String[][] tokens;
            Instance instance = data.getInstance(i);
            Sequence input = (Sequence)instance.getData();
            Sequence predOutput = this.myCRF.viterbiPath(input).output();
            assert (input.size() == predOutput.size());
            tokens = new String[][]{instance.getSource().toString().split("[ \t]+"), new String[tokens[0].length]};
            if (tokens[0].length > 0) {
                for (int j = 0; j < predOutput.size(); ++j) {
                    tokens[1][j] = predOutput.get(j).toString();
                }
            }
            result.add(tokens);
        }
        return result;
    }
}

