package de.julianegner.multiplatformTooltip

import androidx.compose.foundation.combinedClickable
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.ui.Modifier

actual fun Modifier.longPressGesture(
    interactionSource: MutableInteractionSource,
    onLongPress: () -> Unit
): Modifier = this.combinedClickable(
    interactionSource = null, // Use separate interaction source to avoid conflicts
    indication = null, // No visual indication
    onClick = { 
        // println("LongPressGesture: Regular tap detected - not interfering")
    },
    onLongClick = {
        // println("LongPressGesture: LONG PRESS DETECTED with combinedClickable!")
        onLongPress()
    }
)
