package de.julianegner.multiplatformTooltip

object TooltipCounter {
    private val start = 1000
    private var current = start // Start value

    /**
     * zIndex for an Element surrounding a TooltipWrapper
     * ensures that Tooltips are always shown above other Tooltips that are printed later
     * only needed if two elements with tooltips are overlapping
     *
     * Example:
     *         Box(modifier = Modifier
     *             .width(300.dp)
     *             .height(90.dp)
     *             .background(color1)
     *             .padding(20.dp)
     *             .zIndex(TooltipCounter.startIndex) // ensure this is on top of other tooltips
     *         ) {
     *             TooltipWrapper("Tooltip",
     *                 offset = DpOffset(x = 130.dp, y = 70.dp)
     *                 ) {
     *                 Text(
     *                     text = "Test Item 1: Simple Tooltip on Text",
     *                     fontSize = 16.sp,
     *                     textAlign = TextAlign.Center,
     *                     fontWeight = FontWeight.Medium
     *                 )
     *             }
     *         }
     */
    val startIndex = start.toFloat()

    fun next(): Int {
        return current--
    }

    fun getCurrent(): Int {
        return current
    }

    fun reset() {
        current = start
    }
}

