package de.julianegner.multiplatformTooltip

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.offset
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.runtime.Composable
import androidx.compose.material.Text
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.DpOffset
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.TextUnitType
import androidx.compose.ui.unit.dp

// UI element to show the tooltip
@Composable
fun Tooltip(
    text: String,
    offset: DpOffset = DpOffset(0.dp, 0.dp),
) {
    Box(
        modifier =  standardTooltipModifier
            .offset(x = offset.x, y = offset.y)
            .clip(RoundedCornerShape(8.dp))
            .background(Color.LightGray)
            .padding(10.dp)
    ) {
        Text(
            text,
            color = Color.Black,
            fontSize = TextUnit(
                if (isPlatformMobile) 2.4f else 1f, TextUnitType.Em),
            lineHeight = TextUnit(1.5f, TextUnitType.Em)
        )
    }
}

