package de.jsyn.unifi.controller.client.api;

import de.jsyn.unifi.controller.client.ApiException;
import de.jsyn.unifi.controller.client.ApiClient;
import de.jsyn.unifi.controller.client.Configuration;
import de.jsyn.unifi.controller.client.Pair;

import javax.ws.rs.core.GenericType;

import de.jsyn.unifi.controller.client.model.Login;
import de.jsyn.unifi.controller.client.model.LoginResponse;
import de.jsyn.unifi.controller.client.model.Sites;
import de.jsyn.unifi.controller.client.model.WlanConf;
import de.jsyn.unifi.controller.client.model.WlanConfs;
import de.jsyn.unifi.controller.client.model.WlanGroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-10T12:25:42.388268+01:00[Europe/Berlin]")
public class DefaultApi {
  private ApiClient apiClient;

  public DefaultApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DefaultApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Lists all sites of the authenticated user
   * 
   * @return a {@code Sites}
   * @throws ApiException if fails to make API call
   */
  public Sites listSites() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/self/sites".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "CSRF_Token", "Unifises" };

    GenericType<Sites> localVarReturnType = new GenericType<Sites>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Lists the specified WLAN configuation
   * 
   * @param site Name of the site (required)
   * @param confId Id of the WLAN configuration (required)
   * @return a {@code WlanConfs}
   * @throws ApiException if fails to make API call
   */
  public WlanConfs listWlanConfig(String site, String confId) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'site' is set
    if (site == null) {
      throw new ApiException(400, "Missing the required parameter 'site' when calling listWlanConfig");
    }
    
    // verify the required parameter 'confId' is set
    if (confId == null) {
      throw new ApiException(400, "Missing the required parameter 'confId' when calling listWlanConfig");
    }
    
    // create path and map variables
    String localVarPath = "/s/{site}/rest/wlanconf/{confId}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "site" + "\\}", apiClient.escapeString(site.toString()))
      .replaceAll("\\{" + "confId" + "\\}", apiClient.escapeString(confId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "CSRF_Token", "Unifises" };

    GenericType<WlanConfs> localVarReturnType = new GenericType<WlanConfs>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Lists all WLAN configurations
   * 
   * @param site Name of the site (required)
   * @return a {@code WlanConfs}
   * @throws ApiException if fails to make API call
   */
  public WlanConfs listWlanConfigs(String site) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'site' is set
    if (site == null) {
      throw new ApiException(400, "Missing the required parameter 'site' when calling listWlanConfigs");
    }
    
    // create path and map variables
    String localVarPath = "/s/{site}/rest/wlanconf".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "site" + "\\}", apiClient.escapeString(site.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "CSRF_Token", "Unifises" };

    GenericType<WlanConfs> localVarReturnType = new GenericType<WlanConfs>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List all WLAN group
   * 
   * @param site Name of the site (required)
   * @return a {@code WlanGroups}
   * @throws ApiException if fails to make API call
   */
  public WlanGroups listWlanGroups(String site) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'site' is set
    if (site == null) {
      throw new ApiException(400, "Missing the required parameter 'site' when calling listWlanGroups");
    }
    
    // create path and map variables
    String localVarPath = "/s/{site}/rest/wlangroup".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "site" + "\\}", apiClient.escapeString(site.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "CSRF_Token", "Unifises" };

    GenericType<WlanGroups> localVarReturnType = new GenericType<WlanGroups>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Login to controller
   * 
   * @param login Username and password to authenticate. Returns auth cookie (optional)
   * @return a {@code LoginResponse}
   * @throws ApiException if fails to make API call
   */
  public LoginResponse login(Login login) throws ApiException {
    Object localVarPostBody = login;
    
    // create path and map variables
    String localVarPath = "/login".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<LoginResponse> localVarReturnType = new GenericType<LoginResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update the specified WLAN configuration
   * 
   * @param site Name of the site (required)
   * @param confId Id of the WLAN configuration (required)
   * @param wlanConf WLAN configuration (required)
   * @return a {@code WlanConfs}
   * @throws ApiException if fails to make API call
   */
  public WlanConfs updateWlanConfig(String site, String confId, WlanConf wlanConf) throws ApiException {
    Object localVarPostBody = wlanConf;
    
    // verify the required parameter 'site' is set
    if (site == null) {
      throw new ApiException(400, "Missing the required parameter 'site' when calling updateWlanConfig");
    }
    
    // verify the required parameter 'confId' is set
    if (confId == null) {
      throw new ApiException(400, "Missing the required parameter 'confId' when calling updateWlanConfig");
    }
    
    // verify the required parameter 'wlanConf' is set
    if (wlanConf == null) {
      throw new ApiException(400, "Missing the required parameter 'wlanConf' when calling updateWlanConfig");
    }
    
    // create path and map variables
    String localVarPath = "/s/{site}/rest/wlanconf/{confId}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "site" + "\\}", apiClient.escapeString(site.toString()))
      .replaceAll("\\{" + "confId" + "\\}", apiClient.escapeString(confId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "CSRF_Token", "Unifises" };

    GenericType<WlanConfs> localVarReturnType = new GenericType<WlanConfs>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
