/*
 * Decompiled with CFR 0.152.
 */
package de.jplanets.maven.report.frontpage;

import de.jplanets.maven.report.frontpage.ContentItem;
import de.jplanets.maven.report.frontpage.ContentManager;
import de.jplanets.maven.report.frontpage.LayoutManager;
import de.jplanets.maven.report.frontpage.tablelayout.model.TableColumn;
import de.jplanets.maven.report.frontpage.tablelayout.model.TableLayout;
import de.jplanets.maven.report.frontpage.tablelayout.model.TableRow;
import de.jplanets.maven.report.frontpage.tablelayout.model.io.xpp3.TablelayoutXpp3Reader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class TableLayoutManager
implements LayoutManager {
    private TableLayout tableLayout;
    private Sink sink;
    private Doxia doxia;
    private ContentManager contentManager;

    @Override
    public void renderLayout(Locale locale) throws IOException, MavenReportException {
        SinkEventAttributeSet ratts = new SinkEventAttributeSet();
        ratts.addAttribute((Object)"class", (Object)"tableLayout");
        this.sink.table();
        this.sink.tableRows(null, false);
        for (TableRow row : this.tableLayout.getRows()) {
            this.sink.tableRow((SinkEventAttributes)ratts);
            for (TableColumn col : row.getCols()) {
                this.renderCell(col, locale);
            }
            this.sink.tableRow_();
        }
        this.sink.table_();
    }

    private void renderCell(TableColumn col, Locale locale) throws IOException, MavenReportException {
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        if (col.getColspan() > 1) {
            atts.addAttribute((Object)"colspan", (Object)col.getColspan());
        }
        if (col.getRowspan() > 1) {
            atts.addAttribute((Object)"rowspan", (Object)col.getRowspan());
        }
        if (col.getCellClass() != null && col.getCellClass().length() > 0) {
            atts.addAttribute((Object)"class", (Object)col.getCellClass());
        }
        if (col.getCellId() != null && col.getCellId().length() > 0) {
            atts.addAttribute((Object)"id", (Object)col.getCellId());
        }
        this.sink.tableCell((SinkEventAttributes)atts);
        this.renderContent(col, locale);
        this.sink.tableCell_();
    }

    private void renderContent(TableColumn col, Locale locale) throws IOException, MavenReportException {
        ContentItem cItem = null;
        cItem = col.getContentId() != null && col.getContentId().length() > 0 ? this.contentManager.contentById(col.getContentId(), locale) : this.contentManager.nextContent(locale);
        if (cItem != null) {
            try {
                Parser parser = this.doxia.getParser(cItem.getContentType());
                parser.parse(cItem.getContent(), this.sink);
            }
            catch (ParserNotFoundException e) {
                throw new MavenReportException("No parser of type '" + cItem.getContentType() + "' for table layout.", (Exception)((Object)e));
            }
            catch (ParseException e) {
                throw new MavenReportException("Error parsing content for table layout.", (Exception)((Object)e));
            }
        } else {
            this.sink.nonBreakingSpace();
        }
    }

    private void parseFastSetup() {
        String simpleFormat = this.tableLayout.getFastSetup();
        Pattern colPatter = Pattern.compile("(\\d*)?(?:\\[(\\d*)\\])?(?:\\((.*?)\\)?)?(?:\\{(.*?)\\})?");
        StringTokenizer rowTokenizer = new StringTokenizer(simpleFormat, ":");
        while (rowTokenizer.hasMoreTokens()) {
            TableRow tr = new TableRow();
            this.tableLayout.addRow(tr);
            String row = rowTokenizer.nextToken();
            StringTokenizer colTokenizer = new StringTokenizer(row, "-");
            while (colTokenizer.hasMoreTokens()) {
                String col = colTokenizer.nextToken();
                TableColumn td = new TableColumn();
                tr.addCol(td);
                Matcher m = colPatter.matcher(col);
                if (!m.matches()) continue;
                String colspan = m.group(1);
                if (colspan == null) {
                    colspan = "1";
                }
                td.setColspan(Integer.parseInt(colspan));
                String rowspan = m.group(2);
                if (rowspan == null) {
                    rowspan = "1";
                }
                td.setRowspan(Integer.parseInt(rowspan));
                String conId = m.group(3);
                if (conId == null) {
                    conId = "";
                }
                td.setContentId(conId);
                String style = m.group(4);
                if (style == null || style.length() <= 1) {
                    td.setCellClass("");
                    td.setCellId("");
                    continue;
                }
                if (style.startsWith(".")) {
                    td.setCellClass(style.substring(1));
                    td.setCellId("");
                    continue;
                }
                if (style.startsWith("#")) {
                    td.setCellClass("");
                    td.setCellId(style.substring(1));
                    continue;
                }
                td.setCellClass("");
                td.setCellId("");
            }
        }
    }

    @Override
    public void configureXML(Reader reader) throws IOException {
        try {
            this.tableLayout = new TablelayoutXpp3Reader().read(reader);
            if (this.tableLayout.getFastSetup() != null) {
                this.parseFastSetup();
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException("Exception parsing configuration.", e);
        }
    }

    public void configureFastSetup(String fastSetup) {
        this.tableLayout = new TableLayout();
        this.tableLayout.setFastSetup(fastSetup);
        this.parseFastSetup();
    }

    public final TableLayout getTableLayout() {
        return this.tableLayout;
    }

    public final void setTableLayout(TableLayout tableLayout) {
        this.tableLayout = tableLayout;
    }

    public final Sink getSink() {
        return this.sink;
    }

    @Override
    public final void setSink(Sink sink) {
        this.sink = sink;
    }

    public final Doxia getDoxia() {
        return this.doxia;
    }

    @Override
    public final void setDoxia(Doxia doxia) {
        this.doxia = doxia;
    }

    public final ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    public final void setContentManager(ContentManager contentManager) {
        this.contentManager = contentManager;
    }

    @Override
    public final void setMavenProject(MavenProject mavenProject) {
    }
}

