/*
 * Decompiled with CFR 0.152.
 */
package de.jplanets.maven.report.frontpage;

import de.jplanets.maven.report.frontpage.ContentManager;
import de.jplanets.maven.report.frontpage.FrontpageManager;
import de.jplanets.maven.report.frontpage.LayoutManager;
import de.jplanets.maven.report.frontpage.model.FrontpageModel;
import de.jplanets.maven.report.frontpage.model.io.xpp3.FrontpageXpp3Reader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FrontpageReport
extends AbstractMavenReport {
    private String outputDirectory;
    private MavenProject project;
    private Renderer siteRenderer;
    private Doxia doxia;
    private FrontpageManager frontpageManager;
    private File model;
    private Map<Locale, FrontpageModel> frontpageModels = new HashMap<Locale, FrontpageModel>();
    private Locale defaultLocale = null;

    protected void executeReport(Locale locale) throws MavenReportException {
        this.putDefaultLocale(locale);
        this.loadModel(locale);
        FrontpageModel frontpageModel = this.frontpageModels.get(locale);
        ContentManager contentManager = this.frontpageManager.getContentManager(frontpageModel.getContent().getType());
        Xpp3Dom contentConfiguration = (Xpp3Dom)frontpageModel.getContent().getConfiguration();
        try {
            contentManager.setMavenProject(this.project);
            contentManager.configureXML(new StringReader(contentConfiguration.toString()));
        }
        catch (IOException e) {
            throw new MavenReportException("Could not configure the ContentManager", (Exception)e);
        }
        LayoutManager layoutManager = this.frontpageManager.getLayoutManager(frontpageModel.getLayout().getType());
        Xpp3Dom layoutConfiguration = (Xpp3Dom)frontpageModel.getLayout().getConfiguration();
        try {
            layoutManager.setContentManager(contentManager);
            layoutManager.setDoxia(this.doxia);
            layoutManager.setSink(this.getSink());
            layoutManager.setMavenProject(this.project);
            layoutManager.configureXML(new StringReader(layoutConfiguration.toString()));
        }
        catch (IOException e) {
            throw new MavenReportException("Could not configure the LayoutManager", (Exception)e);
        }
        try {
            if (locale.equals(this.defaultLocale)) {
                layoutManager.renderLayout(null);
            } else {
                layoutManager.renderLayout(locale);
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Could not render the layout", (Exception)e);
        }
    }

    private void loadModel(Locale locale) throws MavenReportException {
        this.putDefaultLocale(locale);
        if (this.frontpageModels.get(locale) != null) {
            return;
        }
        try {
            File modelFile = this.model;
            if (locale != null && !this.defaultLocale.equals(locale) && !(modelFile = new File(this.model.getParent(), locale + File.separator + this.model.getName())).exists()) {
                this.getLog().info((CharSequence)("Using default model file for locale " + locale + "."));
                modelFile = this.model;
            }
            FrontpageModel frontpageModel = new FrontpageXpp3Reader().read(new FileReader(modelFile));
            this.frontpageModels.put(locale, frontpageModel);
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("FileNotFoundException for '" + this.model.getAbsolutePath() + "'", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException("IOException for '" + this.model.getAbsolutePath() + "'", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MavenReportException("XmlPullParserException for '" + this.model.getAbsolutePath() + "'", (Exception)((Object)e));
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        this.putDefaultLocale(locale);
        return "The FrontPageReport";
    }

    public String getName(Locale locale) {
        this.putDefaultLocale(locale);
        return "FrontPageReport";
    }

    public String getOutputName() {
        try {
            this.loadModel(null);
        }
        catch (MavenReportException e) {
            this.getLog().warn((CharSequence)"Loading model failed. Using 'frontpage' as output name", (Throwable)e);
            return "frontpage";
        }
        return this.frontpageModels.get(null).getOutputName();
    }

    private void putDefaultLocale(Locale locale) {
        if (this.defaultLocale == null && locale != null) {
            this.defaultLocale = locale;
        }
    }
}

