/*
 * Decompiled with CFR 0.152.
 */
package de.jplanets.maven.report.frontpage;

import de.jplanets.maven.report.frontpage.ContentItem;
import de.jplanets.maven.report.frontpage.ContentManager;
import de.jplanets.maven.report.frontpage.defaultcontent.model.DefaultContent;
import de.jplanets.maven.report.frontpage.defaultcontent.model.Item;
import de.jplanets.maven.report.frontpage.defaultcontent.model.io.xpp3.DefaultContentXpp3Reader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultContentManager
implements ContentManager {
    private MavenProject project;
    private DefaultContent defaultContent;
    private int contentCount = 0;

    @Override
    public ContentItem contentById(String contentId, Locale locale) throws IOException {
        for (Item item : this.defaultContent.getItems()) {
            if (item.getId() == null || !item.getId().equals(contentId)) continue;
            return this.item2contentItem(item, locale);
        }
        return null;
    }

    @Override
    public ContentItem nextContent(Locale locale) throws IOException {
        if (this.contentCount >= this.defaultContent.getItems().size()) {
            return null;
        }
        Item item = this.defaultContent.getItems().get(this.contentCount++);
        return this.item2contentItem(item, locale);
    }

    private ContentItem item2contentItem(Item item, Locale locale) throws FileNotFoundException {
        String type = item.getType();
        if (type == null) {
            type = item.getFilename().substring(item.getFilename().lastIndexOf(46) + 1);
        }
        ContentItem contentItem = new ContentItem();
        contentItem.setContentType(type);
        if (item.getContent() == null || item.getContent().trim().length() == 0) {
            File tryContent;
            File contentFile = new File(this.project.getBasedir() + "/" + item.getLocation() + "/" + type + "/" + item.getFilename());
            if (locale != null && (tryContent = new File(this.project.getBasedir() + "/" + item.getLocation() + "/" + locale + "/" + type + "/" + item.getFilename())).canRead()) {
                contentFile = tryContent;
            }
            contentItem.setContent(new FileReader(contentFile));
        } else {
            contentItem.setContent(new StringReader(item.getContent()));
        }
        return contentItem;
    }

    @Override
    public void reset() {
        this.contentCount = 0;
    }

    @Override
    public void configureXML(Reader reader) throws IOException {
        try {
            this.defaultContent = new DefaultContentXpp3Reader().read(reader);
            this.reset();
        }
        catch (XmlPullParserException e) {
            throw new IOException("Exception parsing configuration.", e);
        }
    }

    @Override
    public final void setMavenProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    public final DefaultContent getDefaultContent() {
        return this.defaultContent;
    }

    public final void setDefaultContent(DefaultContent defaultContent) {
        this.defaultContent = defaultContent;
    }
}

