/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.typescript.grammar;

import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

abstract class TypeScriptLexerBase
extends Lexer {
    private final Deque<Boolean> scopeStrictModes = new ArrayDeque<Boolean>();
    private Token lastToken = null;
    private boolean useStrictDefault = false;
    private boolean useStrictCurrent = false;
    private int templateDepth = 0;
    private int openBracesCount = 0;

    protected TypeScriptLexerBase(CharStream input) {
        super(input);
    }

    public boolean getStrictDefault() {
        return this.useStrictDefault;
    }

    public void setUseStrictDefault(boolean value) {
        this.useStrictDefault = value;
        this.useStrictCurrent = value;
    }

    public boolean isStrictMode() {
        return this.useStrictCurrent;
    }

    public void startTemplateString() {
        this.openBracesCount = 0;
    }

    public boolean isInTemplateString() {
        return this.templateDepth > 0 && this.openBracesCount == 0;
    }

    public Token nextToken() {
        Token next = super.nextToken();
        if (next.getChannel() == 0) {
            this.lastToken = next;
        }
        return next;
    }

    protected void processOpenBrace() {
        ++this.openBracesCount;
        this.useStrictCurrent = !this.scopeStrictModes.isEmpty() && this.scopeStrictModes.peek() != false || this.useStrictDefault;
        this.scopeStrictModes.push(this.useStrictCurrent);
    }

    protected void processCloseBrace() {
        --this.openBracesCount;
        this.useStrictCurrent = this.scopeStrictModes.isEmpty() ? this.useStrictDefault : this.scopeStrictModes.pop();
    }

    protected void processStringLiteral() {
        String text;
        if ((this.lastToken == null || this.lastToken.getType() == 8) && ((text = this.getText()).equals("\"use strict\"") || text.equals("'use strict'"))) {
            if (!this.scopeStrictModes.isEmpty()) {
                this.scopeStrictModes.pop();
            }
            this.useStrictCurrent = true;
            this.scopeStrictModes.push(true);
        }
    }

    protected void increaseTemplateDepth() {
        ++this.templateDepth;
    }

    protected void decreaseTemplateDepth() {
        --this.templateDepth;
    }

    protected boolean isRegexPossible() {
        if (this.lastToken == null) {
            return true;
        }
        return switch (this.lastToken.getType()) {
            case 5, 7, 18, 19, 55, 56, 57, 58, 59, 80, 124, 125 -> false;
            default -> true;
        };
    }
}

