/*
 * Decompiled with CFR 0.152.
 */
package jplag.text;

import de.jplag.Language;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.TokenType;
import de.jplag.text.NaturalLanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NaturalLanguageTest {
    private final Logger logger = LoggerFactory.getLogger(NaturalLanguageTest.class);
    private static final Path BASE_PATH = Path.of("src", "test", "resources");
    private static final String TEST_SUBJECT = "FutureJavaDoc.txt";
    private Language language;
    private File baseDirectory;

    NaturalLanguageTest() {
    }

    @BeforeEach
    public void setUp() {
        this.language = new NaturalLanguage();
        this.baseDirectory = BASE_PATH.toFile();
        Assertions.assertTrue((boolean)this.baseDirectory.exists(), (String)"Could not find base directory!");
    }

    @Test
    void testParsingJavaDoc() throws ParsingException {
        List result = this.language.parse(Set.of(new File(BASE_PATH.toFile(), TEST_SUBJECT)));
        this.logger.info(TokenPrinter.printTokens((List)result, (File)this.baseDirectory));
        List<TokenType> tokenTypes = result.stream().map(Token::getType).toList();
        Assertions.assertEquals((int)283, (int)tokenTypes.size());
        Assertions.assertEquals((int)158, (int)new HashSet<TokenType>(tokenTypes).size());
    }

    @ParameterizedTest
    @ValueSource(strings={"\n", "\r", "\r\n"})
    void testLineBreakInputs(String input) throws IOException, ParsingException {
        File testFile = File.createTempFile("input", "txt");
        Files.writeString(testFile.toPath(), (CharSequence)input, new OpenOption[0]);
        List result = this.language.parse(Set.of(testFile));
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"\ntoken", "\rtoken", "\r\ntoken"})
    void testTokenAfterLineBreak(String input) throws IOException, ParsingException {
        File testFile = File.createTempFile("input", "txt");
        Files.writeString(testFile.toPath(), (CharSequence)input, new OpenOption[0]);
        List result = this.language.parse(Set.of(testFile));
        Assertions.assertEquals((int)2, (int)((Token)result.get(0)).getLine());
    }
}

