/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.scxml.util;

import de.jplag.scxml.parser.model.State;
import de.jplag.scxml.parser.model.Transition;
import de.jplag.scxml.parser.model.executable_content.Action;
import de.jplag.scxml.parser.model.executable_content.ExecutableContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StateBuilder {
    private final String id;
    private final List<Action> actions = new ArrayList<Action>();
    private ArrayList<Transition> transitions = new ArrayList();
    private List<State> substates = new ArrayList<State>();
    private boolean initial;
    private boolean parallel;

    public StateBuilder(String id) {
        this.id = id;
    }

    public StateBuilder setParallel() {
        this.parallel = true;
        return this;
    }

    public StateBuilder setInitial() {
        this.initial = true;
        return this;
    }

    public StateBuilder addTransitions(Transition ... transitions) {
        this.transitions = new ArrayList<Transition>(List.of(transitions));
        return this;
    }

    public StateBuilder addSubstates(State ... substates) {
        this.substates = Arrays.asList(substates);
        return this;
    }

    public StateBuilder addOnEntry(ExecutableContent ... contents) {
        this.actions.add(new Action(Action.Type.ON_ENTRY, List.of(contents)));
        return this;
    }

    public StateBuilder addOnExit(ExecutableContent ... contents) {
        this.actions.add(new Action(Action.Type.ON_EXIT, List.of(contents)));
        return this;
    }

    public State build() {
        return new State(this.id, this.transitions, this.substates, this.actions, this.initial, this.parallel);
    }
}

