/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.scxml;

import de.jplag.ParsingException;
import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.scxml.ConfigurableScxmlParserAdapter;
import de.jplag.scxml.ScxmlTokenType;
import de.jplag.scxml.parser.ScxmlParserAdapter;
import de.jplag.scxml.parser.SimpleScxmlTokenGenerator;
import de.jplag.scxml.sorting.NoOpSortingStrategy;
import de.jplag.scxml.sorting.RecursiveSortingStrategy;
import de.jplag.scxml.sorting.SortingStrategy;
import de.jplag.scxml.util.AbstractScxmlVisitor;
import de.jplag.testutils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class ScxmlTokenGeneratorTest {
    private static final Path BASE_PATH = Path.of("src", "test", "resources", "de", "jplag", "statecharts");
    private final File baseDirectory = BASE_PATH.toFile();

    ScxmlTokenGeneratorTest() {
    }

    private List<TokenType> getTokenTypes(ScxmlParserAdapter adapter, File testFile) throws ParsingException {
        return adapter.parse(Set.of(testFile)).stream().map(Token::getType).toList();
    }

    @Test
    void testRecursiveSorter() throws ParsingException {
        File originalTestFile = new File(this.baseDirectory, TestSubjects.COMPLEX.fileName);
        ConfigurableScxmlParserAdapter adapter = new ConfigurableScxmlParserAdapter();
        SimpleScxmlTokenGenerator visitor = new SimpleScxmlTokenGenerator((ScxmlParserAdapter)adapter);
        adapter.configure((AbstractScxmlVisitor)visitor, (SortingStrategy)new NoOpSortingStrategy());
        List<TokenType> expectedTokenTypes = List.of(ScxmlTokenType.STATE, ScxmlTokenType.STATE, ScxmlTokenType.TRANSITION, ScxmlTokenType.ASSIGNMENT, ScxmlTokenType.TRANSITION_END, ScxmlTokenType.STATE_END, ScxmlTokenType.STATE, ScxmlTokenType.ON_ENTRY, ScxmlTokenType.ASSIGNMENT, ScxmlTokenType.ACTION_END, ScxmlTokenType.TRANSITION, ScxmlTokenType.TRANSITION_END, ScxmlTokenType.STATE, ScxmlTokenType.ON_ENTRY, ScxmlTokenType.IF, ScxmlTokenType.ASSIGNMENT, ScxmlTokenType.IF_END, ScxmlTokenType.ACTION_END, ScxmlTokenType.TRANSITION, ScxmlTokenType.TRANSITION_END, ScxmlTokenType.STATE_END, ScxmlTokenType.STATE, ScxmlTokenType.ON_ENTRY, ScxmlTokenType.SEND, ScxmlTokenType.ACTION_END, ScxmlTokenType.ON_EXIT, ScxmlTokenType.CANCEL, ScxmlTokenType.ACTION_END, ScxmlTokenType.TRANSITION, ScxmlTokenType.TRANSITION_END, ScxmlTokenType.TRANSITION, ScxmlTokenType.TRANSITION_END, ScxmlTokenType.STATE_END, ScxmlTokenType.STATE_END, ScxmlTokenType.STATE_END, SharedTokenType.FILE_END);
        List<TokenType> originalTokenTypes = this.getTokenTypes(adapter, originalTestFile);
        org.junit.jupiter.api.Assertions.assertEquals(expectedTokenTypes, originalTokenTypes);
        adapter.setSorter((SortingStrategy)new RecursiveSortingStrategy((AbstractScxmlVisitor)visitor));
        File reorderedTestFile = new File(this.baseDirectory, TestSubjects.COMPLEX_REORDERED.fileName);
        List<TokenType> reorderedTokenTypes = this.getTokenTypes(adapter, reorderedTestFile);
        org.junit.jupiter.api.Assertions.assertEquals(expectedTokenTypes, reorderedTokenTypes);
    }

    @Test
    void testCoverage() throws ParsingException {
        File testFile = new File(this.baseDirectory, TestSubjects.COVERAGE.fileName);
        ScxmlParserAdapter adapter = new ScxmlParserAdapter();
        List<TokenType> actualUniqueTokenTypes = this.getTokenTypes(adapter, testFile).stream().filter(x -> x != SharedTokenType.FILE_END).distinct().toList();
        Assertions.assertThat(actualUniqueTokenTypes).containsExactlyInAnyOrder((Object[])ScxmlTokenType.values());
    }

    @Test
    void testViewFile() throws ParsingException, IOException {
        File testFile = new File(this.baseDirectory, TestSubjects.COMPLEX.fileName);
        ScxmlParserAdapter adapter = new ScxmlParserAdapter();
        adapter.parse(Set.of(testFile));
        File viewFile = new File(testFile.getPath() + ".scxmlview");
        File expectedViewFile = new File(this.baseDirectory, TestSubjects.COMPLEX_VIEW_FILE.fileName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)viewFile.exists());
        org.junit.jupiter.api.Assertions.assertEquals(Files.readAllLines(expectedViewFile.toPath()), Files.readAllLines(viewFile.toPath()));
    }

    @AfterEach
    void tearDown() {
        FileUtil.clearFiles((File)new File(BASE_PATH.toString()), (String)".scxmlview");
    }

    static enum TestSubjects {
        COMPLEX("complex.scxml"),
        COMPLEX_REORDERED("complex_reordered.scxml"),
        COMPLEX_VIEW_FILE("complex_expected_scxmlview"),
        COVERAGE("coverage.scxml");

        final String fileName;

        private TestSubjects(String fileName) {
            this.fileName = fileName;
        }

        public String toString() {
            return super.toString();
        }
    }
}

