/* SchemeParser.java */
/* Generated by:  java; page-delimiter&ParserGeneratorCC: Do not edit this line. SchemeParser.java */
package de.jplag.scheme;

import static de.jplag.scheme.SchemeTokenType.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import java.io.IOException;
import java.nio.charset.Charset;

import de.jplag.ParsingException;
import de.jplag.util.FileUtils;

public class SchemeParser implements SchemeParserConstants {
    /* used for context in the template production rule */
    private static int templateParam;
    private Parser parser2;

    public static void parseFile(File file, SchemeParser parser, Parser parserX) throws ParsingException {
        try {
            FileInputStream in = new FileInputStream(file);
            Charset charset = FileUtils.detectCharset(file);
            if (parser == null) {
                parser = new SchemeParser(in, charset.name());
            } else {
                parser.ReInit(in, charset.name());
            }
            parser.parser2 = parserX;
        } catch (FileNotFoundException e) {
            System.out.println("Scheme Parser R4RS:  File " + file.getName() + " not found.");
            throw new ParsingException(file, e.getMessage(), e);
        } catch (IOException e) {
            throw new ParsingException(file, e.getMessage(), e);
        }
        try {
            parser.Program();
        } catch (ParseException e) {
            parserX.logger.error("Parsing Error in '" + file.getName() + "': " + e.getMessage());
            throw new ParsingException(file, e.getMessage(), e);
        } catch (TokenMgrException e) {
            parserX.logger.error("Scanning Error in '" + file.getName() + "': " + e.getMessage());
            throw new ParsingException(file, e.getMessage(), e);
        }
    }

  final public void Identifier() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:
    case ARROW:
    case DEFINE:
    case UNQUOTE:
    case UNQUOTE_SPLICING:
    case QUOTE:
    case LAMBDA:
    case IF:
    case SET:
    case BEGIN:
    case COND:
    case AND:
    case OR:
    case CASE:
    case LET:
    case LETSTAR:
    case LETREC:
    case DO:
    case DELAY:
    case QUASIQUOTE:{
      SyntacticKeyword();
      break;
      }
    case VARIABLE:{
      jj_consume_token(VARIABLE);
parser2.add(S_VAR,token);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void SyntacticKeyword() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      break;
      }
    case ARROW:{
      jj_consume_token(ARROW);
      break;
      }
    case DEFINE:{
      jj_consume_token(DEFINE);
      break;
      }
    case UNQUOTE:{
      jj_consume_token(UNQUOTE);
      break;
      }
    case UNQUOTE_SPLICING:{
      jj_consume_token(UNQUOTE_SPLICING);
      break;
      }
    case QUOTE:{
      jj_consume_token(QUOTE);
      break;
      }
    case LAMBDA:{
      jj_consume_token(LAMBDA);
      break;
      }
    case IF:{
      jj_consume_token(IF);
      break;
      }
    case SET:{
      jj_consume_token(SET);
      break;
      }
    case BEGIN:{
      jj_consume_token(BEGIN);
      break;
      }
    case COND:{
      jj_consume_token(COND);
      break;
      }
    case AND:{
      jj_consume_token(AND);
      break;
      }
    case OR:{
      jj_consume_token(OR);
      break;
      }
    case CASE:{
      jj_consume_token(CASE);
      break;
      }
    case LET:{
      jj_consume_token(LET);
      break;
      }
    case LETSTAR:{
      jj_consume_token(LETSTAR);
      break;
      }
    case LETREC:{
      jj_consume_token(LETREC);
      break;
      }
    case DO:{
      jj_consume_token(DO);
      break;
      }
    case DELAY:{
      jj_consume_token(DELAY);
      break;
      }
    case QUASIQUOTE:{
      jj_consume_token(QUASIQUOTE);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/*
 * External representations
 */
  final public 
void Datum() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:
    case ARROW:
    case DEFINE:
    case UNQUOTE:
    case UNQUOTE_SPLICING:
    case QUOTE:
    case LAMBDA:
    case IF:
    case SET:
    case BEGIN:
    case COND:
    case AND:
    case OR:
    case CASE:
    case LET:
    case LETSTAR:
    case LETREC:
    case DO:
    case DELAY:
    case QUASIQUOTE:
    case VARIABLE:
    case BOOLEAN:
    case CHARACTER:
    case STRING:
    case NUMBER:{
      SimpleDatum();
      break;
      }
    case 78:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:{
      CompoundDatum();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void SimpleDatum() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
parser2.add(S_BOOL,token);
      break;
      }
    case NUMBER:{
      jj_consume_token(NUMBER);
parser2.add(S_NUMBER,token);
      break;
      }
    case CHARACTER:{
      jj_consume_token(CHARACTER);
parser2.add(S_CHAR,token);
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
parser2.add(S_STRING,token);
      break;
      }
    case ELSE:
    case ARROW:
    case DEFINE:
    case UNQUOTE:
    case UNQUOTE_SPLICING:
    case QUOTE:
    case LAMBDA:
    case IF:
    case SET:
    case BEGIN:
    case COND:
    case AND:
    case OR:
    case CASE:
    case LET:
    case LETSTAR:
    case LETREC:
    case DO:
    case DELAY:
    case QUASIQUOTE:
    case VARIABLE:{
      Symbol();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Symbol() throws ParseException {
    Identifier();
parser2.add(S_ID,token);
}

  final public void CompoundDatum() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 78:
    case 81:
    case 82:
    case 83:
    case 84:{
      List();
      break;
      }
    case 85:{
      Vector();
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void List() throws ParseException {
parser2.add(S_LIST_BEGIN,token);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 78:{
      jj_consume_token(78);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ELSE:
      case ARROW:
      case DEFINE:
      case UNQUOTE:
      case UNQUOTE_SPLICING:
      case QUOTE:
      case LAMBDA:
      case IF:
      case SET:
      case BEGIN:
      case COND:
      case AND:
      case OR:
      case CASE:
      case LET:
      case LETSTAR:
      case LETREC:
      case DO:
      case DELAY:
      case QUASIQUOTE:
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:{
        label_1:
        while (true) {
          Datum();
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case ELSE:
          case ARROW:
          case DEFINE:
          case UNQUOTE:
          case UNQUOTE_SPLICING:
          case QUOTE:
          case LAMBDA:
          case IF:
          case SET:
          case BEGIN:
          case COND:
          case AND:
          case OR:
          case CASE:
          case LET:
          case LETSTAR:
          case LETREC:
          case DO:
          case DELAY:
          case QUASIQUOTE:
          case VARIABLE:
          case BOOLEAN:
          case CHARACTER:
          case STRING:
          case NUMBER:
          case 78:
          case 81:
          case 82:
          case 83:
          case 84:
          case 85:{
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            break label_1;
          }
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 79:{
          jj_consume_token(79);
          Datum();
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          ;
        }
        jj_consume_token(80);
        break;
        }
      case 80:{
        jj_consume_token(80);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case 81:
    case 82:
    case 83:
    case 84:{
      Abbreviation();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
parser2.add(S_LIST_END,token);
}

  final public void Abbreviation() throws ParseException {
    AbbrevPrefix();
    Datum();
}

  final public void AbbrevPrefix() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 81:{
      jj_consume_token(81);
      break;
      }
    case 82:{
      jj_consume_token(82);
      break;
      }
    case 83:{
      jj_consume_token(83);
      break;
      }
    case 84:{
      jj_consume_token(84);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Vector() throws ParseException {
    jj_consume_token(85);
parser2.add(S_VECTOR_BEGIN,token);
    label_2:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ELSE:
      case ARROW:
      case DEFINE:
      case UNQUOTE:
      case UNQUOTE_SPLICING:
      case QUOTE:
      case LAMBDA:
      case IF:
      case SET:
      case BEGIN:
      case COND:
      case AND:
      case OR:
      case CASE:
      case LET:
      case LETSTAR:
      case LETREC:
      case DO:
      case DELAY:
      case QUASIQUOTE:
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_2;
      }
      Datum();
    }
    jj_consume_token(80);
parser2.add(S_VECTOR_END,token);
}

/*
 * Expressions
 */
  final public 
void Expression() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case VARIABLE:{
      jj_consume_token(VARIABLE);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      if (jj_2_1(2)) {
        Literal();
      } else if (jj_2_2(2)) {
        ProcedureCall();
      } else if (jj_2_3(2)) {
        LambdaExpression();
      } else if (jj_2_4(2)) {
        Conditional();
      } else if (jj_2_5(2)) {
        Assignment();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:
        case 82:{
          DerivedExpression();
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

  final public void Literal() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 78:
    case 81:{
      Quotation();
      break;
      }
    case BOOLEAN:
    case CHARACTER:
    case STRING:
    case NUMBER:{
      SelfEvaluating();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
parser2.add(S_LITERAL,token);
}

  final public void SelfEvaluating() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
parser2.add(S_BOOL,token);
      break;
      }
    case NUMBER:{
      jj_consume_token(NUMBER);
parser2.add(S_NUMBER,token);
      break;
      }
    case CHARACTER:{
      jj_consume_token(CHARACTER);
parser2.add(S_CHAR,token);
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
parser2.add(S_STRING,token);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Quotation() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 81:{
      jj_consume_token(81);
parser2.add(S_QUOT_BEGIN,token);
      Datum();
      break;
      }
    case 78:{
      jj_consume_token(78);
parser2.add(S_QUOT_BEGIN,token);
      jj_consume_token(QUOTE);
      Datum();
      jj_consume_token(80);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
parser2.add(S_QUOT_END,token);
}

  final public void ProcedureCall() throws ParseException {
    jj_consume_token(78);
    Operator();
parser2.add(S_CALL,token);
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:{
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_3;
      }
      Operand();
    }
    jj_consume_token(80);
}

  final public void Operator() throws ParseException {
    Expression();
}

  final public void Operand() throws ParseException {
    Expression();
}

  final public void LambdaExpression() throws ParseException {
    jj_consume_token(78);
parser2.add(S_LAMBDA_BEGIN,token);
    jj_consume_token(LAMBDA);
    Formals();
    Body();
    jj_consume_token(80);
parser2.add(S_LAMBDA_END,token);
}

  final public void Formals() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 78:{
      jj_consume_token(78);
parser2.add(S_FORMAL_BEGIN,token);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:{
        label_4:
        while (true) {
          jj_consume_token(VARIABLE);
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case VARIABLE:{
            break;
            }
          default:
            jj_la1[17] = jj_gen;
            break label_4;
          }
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 79:{
          jj_consume_token(79);
          jj_consume_token(VARIABLE);
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          ;
        }
        jj_consume_token(80);
        break;
        }
      case 80:{
        jj_consume_token(80);
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
parser2.add(S_FORMAL_END,token);
      break;
      }
    case VARIABLE:{
      jj_consume_token(VARIABLE);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void Body() throws ParseException {
    label_5:
    while (true) {
      if (jj_2_6(4)) {
      } else {
        break label_5;
      }
      Definition();
    }
parser2.add(S_BODY_BEGIN,token);
    Sequence();
parser2.add(S_BODY_END,token);
}

  final public void Sequence() throws ParseException {
    label_6:
    while (true) {
      if (jj_2_7(2)) {
        Expression();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:{
          jj_consume_token(78);
parser2.add(S_DEF_BEGIN,token);
          jj_consume_token(DEFINE);
          jj_consume_token(VARIABLE);
          Expression();
          jj_consume_token(80);
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:{
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_6;
      }
    }
}

  final public void Command() throws ParseException {
parser2.add(S_COMMAND,token);
    Expression();
}

  final public void Conditional() throws ParseException {
    jj_consume_token(78);
parser2.add(S_IF_BEGIN,token);
    jj_consume_token(IF);
    Test();
    Consequent();
    Alternate();
    jj_consume_token(80);
parser2.add(S_IF_END,token);
}

  final public void Test() throws ParseException {
    Expression();
}

  final public void Consequent() throws ParseException {
    if (jj_2_8(2)) {
      Expression();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:{
        jj_consume_token(78);
        jj_consume_token(80);
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void Alternate() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case VARIABLE:
    case BOOLEAN:
    case CHARACTER:
    case STRING:
    case NUMBER:
    case 78:
    case 81:
    case 82:{
parser2.add(S_ALTERN,token);
      Expression();
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      ;
    }
}

  final public void Assignment() throws ParseException {
    jj_consume_token(78);
parser2.add(S_ASSIGN_BEGIN,token);
    jj_consume_token(SET);
    jj_consume_token(VARIABLE);
    Expression();
    jj_consume_token(80);
parser2.add(S_ASSIGN_END,token);
}

  final public void DerivedExpression() throws ParseException {
    if (jj_2_13(2)) {
      jj_consume_token(78);
parser2.add(S_COND_BEGIN,token);
      jj_consume_token(COND);
      label_7:
      while (true) {
        if (jj_2_9(2)) {
        } else {
          break label_7;
        }
        CondClause();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:{
        if (jj_2_10(2)) {
          CondClause();
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 78:{
            jj_consume_token(78);
parser2.add(S_ELSE,token);
            jj_consume_token(ELSE);
            Sequence();
            jj_consume_token(80);
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      jj_consume_token(80);
parser2.add(S_COND_END,token);
    } else if (jj_2_14(2)) {
      jj_consume_token(78);
parser2.add(S_CASE_BEGIN,token);
      jj_consume_token(CASE);
      Expression();
      label_8:
      while (true) {
        if (jj_2_11(2)) {
        } else {
          break label_8;
        }
        CaseClause();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:{
        if (jj_2_12(2)) {
          CaseClause();
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 78:{
            jj_consume_token(78);
            jj_consume_token(ELSE);
parser2.add(S_ELSE,token);
            Sequence();
            jj_consume_token(80);
            break;
            }
          default:
            jj_la1[27] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      jj_consume_token(80);
parser2.add(S_CASE_END,token);
    } else if (jj_2_15(2)) {
      jj_consume_token(78);
parser2.add(S_AND,token);
      jj_consume_token(AND);
      label_9:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case VARIABLE:
        case BOOLEAN:
        case CHARACTER:
        case STRING:
        case NUMBER:
        case 78:
        case 81:
        case 82:{
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_9;
        }
        Test();
      }
      jj_consume_token(80);
    } else if (jj_2_16(2)) {
      jj_consume_token(78);
parser2.add(S_OR,token);
      jj_consume_token(OR);
      label_10:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case VARIABLE:
        case BOOLEAN:
        case CHARACTER:
        case STRING:
        case NUMBER:
        case 78:
        case 81:
        case 82:{
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          break label_10;
        }
        Test();
      }
      jj_consume_token(80);
    } else if (jj_2_17(2)) {
      jj_consume_token(78);
parser2.add(S_LET,token);
      jj_consume_token(LET);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:{
        jj_consume_token(VARIABLE);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      jj_consume_token(78);
      label_11:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:{
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_11;
        }
        BindingSpec();
      }
      jj_consume_token(80);
      Body();
      jj_consume_token(80);
    } else if (jj_2_18(2)) {
      jj_consume_token(78);
parser2.add(S_LET,token);
      jj_consume_token(LETSTAR);
      jj_consume_token(78);
      label_12:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:{
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_12;
        }
        BindingSpec();
      }
      jj_consume_token(80);
      Body();
      jj_consume_token(80);
    } else if (jj_2_19(2)) {
      jj_consume_token(78);
parser2.add(S_LET,token);
      jj_consume_token(LETREC);
      jj_consume_token(78);
      label_13:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:{
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_13;
        }
        BindingSpec();
      }
      jj_consume_token(80);
      Body();
      jj_consume_token(80);
    } else if (jj_2_20(2)) {
      jj_consume_token(78);
parser2.add(S_BEGIN,token);
      jj_consume_token(BEGIN);
      Sequence();
      jj_consume_token(80);
parser2.add(S_END,token);
    } else if (jj_2_21(2)) {
      jj_consume_token(78);
parser2.add(S_DO_BEGIN,token);
      jj_consume_token(DO);
      jj_consume_token(78);
      label_14:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 78:{
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_14;
        }
        IterationSpec();
      }
      jj_consume_token(80);
      jj_consume_token(78);
      Test();
      Sequence();
      jj_consume_token(80);
      label_15:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case VARIABLE:
        case BOOLEAN:
        case CHARACTER:
        case STRING:
        case NUMBER:
        case 78:
        case 81:
        case 82:{
          break;
          }
        default:
          jj_la1[36] = jj_gen;
          break label_15;
        }
        Command();
      }
      jj_consume_token(80);
parser2.add(S_DO_END,token);
    } else if (jj_2_22(2)) {
      jj_consume_token(78);
parser2.add(S_DELAY,token);
      jj_consume_token(DELAY);
      Expression();
      jj_consume_token(80);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:
      case 82:{
        Quasiquotation();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void CondClause() throws ParseException {
    jj_consume_token(78);
    Test();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ARROW:
    case VARIABLE:
    case BOOLEAN:
    case CHARACTER:
    case STRING:
    case NUMBER:
    case 78:
    case 81:
    case 82:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:{
        Sequence();
        break;
        }
      case ARROW:{
        jj_consume_token(ARROW);
        Recipient();
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(80);
}

  final public void Recipient() throws ParseException {
    Expression();
}

  final public void CaseClause() throws ParseException {
    jj_consume_token(78);
    jj_consume_token(78);
    label_16:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ELSE:
      case ARROW:
      case DEFINE:
      case UNQUOTE:
      case UNQUOTE_SPLICING:
      case QUOTE:
      case LAMBDA:
      case IF:
      case SET:
      case BEGIN:
      case COND:
      case AND:
      case OR:
      case CASE:
      case LET:
      case LETSTAR:
      case LETREC:
      case DO:
      case DELAY:
      case QUASIQUOTE:
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:{
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        break label_16;
      }
      Datum();
    }
    jj_consume_token(80);
    Sequence();
    jj_consume_token(80);
}

  final public void BindingSpec() throws ParseException {
    jj_consume_token(78);
    jj_consume_token(VARIABLE);
    Expression();
    jj_consume_token(80);
}

  final public void IterationSpec() throws ParseException {
    jj_consume_token(78);
    jj_consume_token(VARIABLE);
    Init();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case VARIABLE:
    case BOOLEAN:
    case CHARACTER:
    case STRING:
    case NUMBER:
    case 78:
    case 81:
    case 82:{
      Step();
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(80);
}

  final public void Init() throws ParseException {
    Expression();
}

  final public void Step() throws ParseException {
    Expression();
}

/*
 * Quasiquotations
 */
  final public 
void Quasiquotation() throws ParseException {
    QuasiquotationD(1);
}

  final public void Template(int d) throws ParseException {templateParam = d;
    if (templateParam == 0) {
      Expression();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ELSE:
      case ARROW:
      case DEFINE:
      case UNQUOTE:
      case UNQUOTE_SPLICING:
      case QUOTE:
      case LAMBDA:
      case IF:
      case SET:
      case BEGIN:
      case COND:
      case AND:
      case OR:
      case CASE:
      case LET:
      case LETSTAR:
      case LETREC:
      case DO:
      case DELAY:
      case QUASIQUOTE:
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:{
        SimpleDatum();
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        if (jj_2_23(2)) {
          ListTemplate(d);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 85:{
            VectorTemplate(d);
            break;
            }
          case 78:
          case 83:{
            Unquotation(d);
            break;
            }
          default:
            jj_la1[43] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
}

  final public void QuasiquotationD(int d) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 82:{
      jj_consume_token(82);
      Template(d);
      break;
      }
    case 78:{
      jj_consume_token(78);
      jj_consume_token(QUASIQUOTE);
      Template(d);
      jj_consume_token(80);
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void ListTemplate(int d) throws ParseException {
    if (jj_2_26(2)) {
      jj_consume_token(78);
      if (jj_2_25(1)) {
        label_17:
        while (true) {
          TemplateOrSplice(d);
          if (jj_2_24(1)) {
          } else {
            break label_17;
          }
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 79:{
          jj_consume_token(79);
          Template(d);
          break;
          }
        default:
          jj_la1[45] = jj_gen;
          ;
        }
        jj_consume_token(80);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case 80:{
          jj_consume_token(80);
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 81:{
        jj_consume_token(81);
        Template(d);
        break;
        }
      case 78:
      case 82:{
        QuasiquotationD(d + 1);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void VectorTemplate(int d) throws ParseException {
    jj_consume_token(85);
    label_18:
    while (true) {
      if (jj_2_27(1)) {
      } else {
        break label_18;
      }
      TemplateOrSplice(d);
    }
    jj_consume_token(80);
}

  final public void Unquotation(int d) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 83:{
      jj_consume_token(83);
      Template(d - 1);
      break;
      }
    case 78:{
      jj_consume_token(78);
      jj_consume_token(UNQUOTE);
      Template(d - 1);
      jj_consume_token(80);
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void TemplateOrSplice(int d) throws ParseException {
    if (jj_2_28(2)) {
      Template(d);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:
      case 84:{
        SplicingUnquotation(d);
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void SplicingUnquotation(int d) throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 84:{
      jj_consume_token(84);
      Template(d - 1);
      break;
      }
    case 78:{
      jj_consume_token(78);
      jj_consume_token(UNQUOTE_SPLICING);
      Template(d - 1);
      jj_consume_token(80);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

/*
 * Programs and definitions
 */
  final public 
void Program() throws ParseException {
    label_19:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case VARIABLE:
      case BOOLEAN:
      case CHARACTER:
      case STRING:
      case NUMBER:
      case 78:
      case 81:
      case 82:{
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        break label_19;
      }
      CommandOrDefinition();
    }
    jj_consume_token(0);
}

  final public void CommandOrDefinition() throws ParseException {
    if (jj_2_29(3)) {
      Command();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:{
        Definition();
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void Definition() throws ParseException {
    if (jj_2_30(3)) {
      jj_consume_token(78);
parser2.add(S_DEF_BEGIN,token);
      jj_consume_token(DEFINE);
      jj_consume_token(VARIABLE);
      Expression();
      jj_consume_token(80);
    } else if (jj_2_31(2)) {
      jj_consume_token(78);
parser2.add(S_DEF_BEGIN,token);
      jj_consume_token(DEFINE);
      jj_consume_token(78);
      jj_consume_token(VARIABLE);
      DefFormals();
      jj_consume_token(80);
      Body();
      jj_consume_token(80);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 78:{
        jj_consume_token(78);
parser2.add(S_DEF_BEGIN,token);
        jj_consume_token(BEGIN);
        label_20:
        while (true) {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case 78:{
            break;
            }
          default:
            jj_la1[53] = jj_gen;
            break label_20;
          }
          Definition();
        }
        jj_consume_token(80);
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
parser2.add(S_DEF_END,token);
}

  final public void DefFormals() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case VARIABLE:{
      label_21:
      while (true) {
        jj_consume_token(VARIABLE);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case VARIABLE:{
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_21;
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case 79:{
        jj_consume_token(79);
        jj_consume_token(VARIABLE);
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_3_6()
 {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    Token xsp;
    if (jj_3R_93()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_93()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    }
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(IF)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VARIABLE)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(COND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_86()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(OR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(LET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) jj_scanpos = xsp;
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(LETSTAR)) return true;
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(LETREC)) return true;
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(BEGIN)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(DO)) return true;
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(DELAY)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    }
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_scan_token(VARIABLE)) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_scan_token(78)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    }
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(CHARACTER)) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = templateParam == 0;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(82)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(QUASIQUOTE)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(78)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    }
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(78)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    }
    return false;
  }

  private boolean jj_3R_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(81)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    if (jj_3R_106()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_106()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_103()) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_scan_token(85)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(83)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(UNQUOTE)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    Token xsp;
    if (jj_3_24()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_scan_token(85)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_104()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    }
    return false;
  }

  private boolean jj_3R_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_scan_token(84)) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_scan_token(78)) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) return true;
    }
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(DEFINE)) return true;
    if (jj_scan_token(VARIABLE)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_scan_token(CHARACTER)) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(DEFINE)) return true;
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(VARIABLE)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(BEGIN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_50()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(81)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_scan_token(78)) return true;
    if (jj_3R_37()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_78()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(80)) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_scan_token(78)) return true;
    if (jj_scan_token(LAMBDA)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) return true;
    }
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(78)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public SchemeParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[58];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xfffff80,0x7ffff80,0xfffff80,0xfffff80,0x0,0xfffff80,0x0,0xfffff80,0x0,0x0,0xfffff80,0x8000000,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x8000000,0x8000000,0x0,0x8000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000100,0x8000100,0xfffff80,0x8000000,0xfffff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x0,0x8000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x158,0x158,0x0,0x158,0x0,0x158,0x0,0x0,0x158,0x0,0x0,0x158,0x158,0x0,0x158,0x0,0x0,0x0,0x0,0x0,0x158,0x0,0x158,0x0,0x0,0x0,0x0,0x158,0x158,0x0,0x0,0x0,0x0,0x0,0x158,0x0,0x158,0x158,0x158,0x158,0x158,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x158,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x3e4000,0x0,0x3e4000,0x3e4000,0x8000,0x3f4000,0x1e4000,0x1e0000,0x3e4000,0x0,0x44000,0x24000,0x0,0x24000,0x64000,0x0,0x8000,0x10000,0x4000,0x4000,0x64000,0x4000,0x64000,0x4000,0x4000,0x4000,0x4000,0x64000,0x64000,0x0,0x4000,0x4000,0x4000,0x4000,0x64000,0x44000,0x64000,0x64000,0x3e4000,0x64000,0x0,0x284000,0x44000,0x8000,0x10000,0x64000,0x84000,0x104000,0x104000,0x64000,0x4000,0x4000,0x4000,0x0,0x8000,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[31];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public SchemeParser(final java.io.InputStream stream, final String encoding) {
   try {
     jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
   } catch(final java.io.UnsupportedEncodingException e) {
     throw new IllegalStateException(e);
   }
	 token_source = new SchemeParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 58; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public void ReInit(final java.io.InputStream stream, final String encoding) {
	  try {
      jj_input_stream.reInit(stream, encoding, 1, 1);
    } catch(final java.io.UnsupportedEncodingException e) { 
      throw new IllegalStateException(e);
    }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 58; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public SchemeParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new SchemeParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 58; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new SchemeParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 58; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public SchemeParser(final SchemeParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 58; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final SchemeParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 58; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    final Token nt = jj_nt = token.next;
    final int ret;
    if (nt == null) {
      token.next = token_source.getNextToken();
      ret = jj_ntk = token.next.kind;
    }
    else
      ret = jj_ntk = nt.kind;
    return ret;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[86];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 58; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 86; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 31; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
