/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.scala;

import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.scala.Language;
import de.jplag.scala.ScalaTokenType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScalaLanguageTest {
    private static final String COMPLETE_TEST_FILE = "Complete.scala";
    private static final String EMPTY_OR_SINGLE_LINE_COMMENT = "\\s*(//.*|/\\*.*\\*/)?";
    private static final String DELIMITED_COMMENT_START = "\\s*/\\*(?:(?!\\*/).)*$";
    private static final String DELIMITED_COMMENT_END = ".*\\*/\\s*$";
    private static final double EPSILON = 1.0E-6;
    private final Logger logger = LoggerFactory.getLogger(ScalaLanguageTest.class);
    private final String[] testFiles = new String[]{"Parser.scala", "Complete.scala"};
    private final File testFileLocation = Path.of("src", "test", "resources", "de", "jplag", "scala").toFile();
    private Language language;

    ScalaLanguageTest() {
    }

    @BeforeEach
    void setup() {
        this.language = new Language();
    }

    @Test
    void parseTestFiles() {
        for (String fileName : this.testFiles) {
            List tokens = this.language.parse(Set.of(new File(this.testFileLocation, fileName)));
            String output = TokenPrinter.printTokens((List)tokens, (File)this.testFileLocation);
            this.logger.info(output);
            if (fileName.equals(COMPLETE_TEST_FILE)) {
                this.testTokenCoverage(tokens, fileName);
            }
            this.testSourceCoverage(fileName, tokens);
        }
    }

    private void testSourceCoverage(String fileName, List<Token> tokens) {
        File testFile = new File(this.testFileLocation, fileName);
        try {
            List<String> lines = Files.readAllLines(testFile.toPath());
            ArrayList<Integer> codeLines = new ArrayList<Integer>(this.getCodeLines(lines));
            List<Integer> tokenLines = tokens.stream().map(Token::getLine).distinct().toList();
            codeLines.removeAll(tokenLines);
            double coverage = 1.0 - (double)codeLines.size() * 1.0 / (double)(codeLines.size() + tokenLines.size());
            if (coverage == 1.0) {
                this.logger.info("All lines covered.");
            } else {
                this.logger.info("Coverage: %.1f%%.".formatted(coverage * 100.0));
                this.logger.info("Missing lines {}", codeLines);
                if (coverage - 0.9 <= 1.0E-6) {
                    Assertions.fail((String)"Source coverage is unsatisfactory");
                }
            }
        }
        catch (IOException exception) {
            this.logger.info("Error while reading test file %s".formatted(fileName), (Throwable)exception);
            Assertions.fail();
        }
    }

    private List<Integer> getCodeLines(List<String> lines) {
        Object state = new Object(){
            boolean insideComment = false;
        };
        return IntStream.rangeClosed(1, lines.size()).sequential().filter(arg_0 -> ScalaLanguageTest.lambda$getCodeLines$0(lines, state, arg_0)).boxed().toList();
    }

    private void testTokenCoverage(List<Token> tokens, String fileName) {
        Set annotatedTokens = tokens.stream().map(Token::getType).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)annotatedTokens.contains(SharedTokenType.FILE_END));
        Set annotatedScalaTokens = annotatedTokens.stream().filter(ScalaTokenType.class::isInstance).collect(Collectors.toSet());
        ScalaTokenType[] allScalaTokens = ScalaTokenType.values();
        List<ScalaTokenType> missingScalaTokens = Arrays.stream(allScalaTokens).filter(token -> !annotatedScalaTokens.contains(token)).toList();
        Assertions.assertTrue((boolean)missingScalaTokens.isEmpty(), (String)("The following scala tokens are missing in the code example '%s':\n".formatted(fileName) + String.join((CharSequence)"\n", missingScalaTokens.stream().map(ScalaTokenType::getDescription).toList())));
    }

    private static /* synthetic */ boolean lambda$getCodeLines$0(List lines, 1 state, int idx) {
        String line = (String)lines.get(idx - 1);
        if (line.matches(EMPTY_OR_SINGLE_LINE_COMMENT)) {
            return false;
        }
        if (line.matches(DELIMITED_COMMENT_START)) {
            state.insideComment = true;
            return false;
        }
        if (state.insideComment) {
            if (line.matches(DELIMITED_COMMENT_END)) {
                state.insideComment = false;
            }
            return false;
        }
        return true;
    }
}

