/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rust.grammar;

import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

public abstract class RustLexerBase
extends Lexer {
    private Token currentToken;
    private Token previousToken;

    protected RustLexerBase(CharStream input) {
        super(input);
    }

    public Token nextToken() {
        Token next = super.nextToken();
        if (next.getChannel() == 0) {
            this.previousToken = this.currentToken;
            this.currentToken = next;
        }
        return next;
    }

    public boolean atFileStart() {
        return this._input.LA(-1) == -1;
    }

    public boolean floatDotPossible() {
        if (this.lookAheadMatchesOneOf(".", "_")) {
            return false;
        }
        if (this.lookAheadMatchesOneOf("f32", "f64")) {
            return true;
        }
        int next = this._input.LA(1);
        return !Character.isAlphabetic(next);
    }

    private boolean lookAheadMatches(String expected) {
        for (int charIndex = 0; charIndex < expected.length(); ++charIndex) {
            if (this._input.LA(charIndex + 1) == expected.charAt(charIndex)) continue;
            return false;
        }
        return true;
    }

    private boolean lookAheadMatchesOneOf(String ... expected) {
        return Arrays.stream(expected).anyMatch(this::lookAheadMatches);
    }

    public boolean floatLiteralPossible() {
        if (this.currentToken == null || this.currentToken.getType() != 112 || this.previousToken == null) {
            return true;
        }
        int type = this.previousToken.getType();
        List<Integer> noFloatLiteralTypes = List.of(69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 28, 24, 25, 5, 56, 106, 126, 128, 130, 37, 57, 58, 54);
        return !noFloatLiteralTypes.contains(type);
    }
}

