/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rust;

import de.jplag.rust.RustTokenType;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;

public class ParserState<C extends Context> {
    private final Deque<C> blockContexts = new LinkedList<C>();

    protected void enter(C context) {
        this.blockContexts.push(context);
    }

    @SafeVarargs
    protected final void leaveAsserted(C ... contexts) {
        Context topContext = (Context)this.blockContexts.pop();
        assert (Arrays.stream(contexts).anyMatch(context -> context == topContext));
    }

    protected C getCurrentContext() {
        return (C)((Context)this.blockContexts.peek());
    }

    protected void leaveIfInContext(C blockContext) {
        if (this.blockContexts.peek() == blockContext) {
            this.blockContexts.pop();
        }
    }

    protected static interface Context {
        public Optional<RustTokenType> getStartType();

        public Optional<RustTokenType> getEndType();
    }
}

