/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rust;

import de.jplag.ParsingException;
import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.rust.Language;
import de.jplag.rust.RustTokenType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RustLanguageTest {
    private static final String RUST_EMPTY_OR_SINGLE_LINE_COMMENT = "\\s*(?://.*)?";
    private static final String RUST_MULTILINE_COMMENT_BEGIN = "\\s*/\\*.*";
    private static final String RUST_MULTILINE_COMMENT_END = ".*\\*/\\s*";
    private static final String COMPLETE_TEST_FILE = "complete.rs";
    private static final String RUST_SHEBANG = "#!.*$";
    private static final double EPSILON = 1.0E-6;
    public static final double BASELINE_COVERAGE = 0.75;
    private final Logger logger = LoggerFactory.getLogger(RustLanguageTest.class);
    private final String[] testFiles = new String[]{"deno_core_runtime.rs", "complete.rs"};
    private final File testFileLocation = Path.of("src", "test", "resources", "de", "jplag", "rust").toFile();
    private Language language;

    RustLanguageTest() {
    }

    @BeforeEach
    void setup() {
        this.language = new Language();
    }

    @Test
    void parseTestFiles() throws ParsingException {
        for (String fileName : this.testFiles) {
            List tokens = this.language.parse(Set.of(new File(this.testFileLocation, fileName)));
            String output = TokenPrinter.printTokens((List)tokens, (File)this.testFileLocation);
            this.logger.info(output);
            this.testSourceCoverage(fileName, tokens);
            if (!fileName.equals(COMPLETE_TEST_FILE)) continue;
            this.testTokenCoverage(tokens, fileName);
        }
    }

    private void testSourceCoverage(String fileName, List<Token> tokens) {
        File testFile = new File(this.testFileLocation, fileName);
        try {
            List<String> lines = Files.readAllLines(testFile.toPath());
            ArrayList<Integer> codeLines = new ArrayList<Integer>(this.getCodeLines(lines));
            List<Integer> tokenLines = tokens.stream().mapToInt(Token::getLine).filter(line -> line != -1).distinct().boxed().toList();
            codeLines.removeAll(tokenLines);
            double coverage = 1.0 - (double)codeLines.size() * 1.0 / (double)(codeLines.size() + tokenLines.size());
            if (coverage == 1.0) {
                this.logger.info("All lines covered.");
            } else {
                this.logger.info("Coverage: %.1f%%.".formatted(coverage * 100.0));
                this.logger.info("Missing lines {}", codeLines);
                Assertions.assertTrue((coverage - 0.75 >= 1.0E-6 ? 1 : 0) != 0, (String)"Source coverage is unsatisfactory");
            }
        }
        catch (IOException exception) {
            this.logger.info("Error while reading test file %s".formatted(fileName), (Throwable)exception);
            Assertions.assertTrue((boolean)false);
        }
    }

    private List<Integer> getCodeLines(List<String> lines) {
        Object state = new Object(){
            boolean insideMultilineComment = false;
        };
        return IntStream.range(1, lines.size() + 1).sequential().filter(arg_0 -> RustLanguageTest.lambda$getCodeLines$1(lines, state, arg_0)).boxed().toList();
    }

    private void testTokenCoverage(List<Token> tokens, String fileName) {
        Set annotatedTokens = tokens.stream().map(Token::getType).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)annotatedTokens.contains(SharedTokenType.FILE_END));
        Set annotatedRustTokens = annotatedTokens.stream().filter(RustTokenType.class::isInstance).collect(Collectors.toSet());
        RustTokenType[] allRustTokens = RustTokenType.values();
        List<RustTokenType> missingRustTokens = Arrays.stream(allRustTokens).filter(token -> !annotatedRustTokens.contains(token)).toList();
        Assertions.assertTrue((boolean)missingRustTokens.isEmpty(), (String)("The following rust tokens are missing in the code example '%s':\n".formatted(fileName) + String.join((CharSequence)"\n", missingRustTokens.stream().map(RustTokenType::getDescription).toList())));
    }

    private static /* synthetic */ boolean lambda$getCodeLines$1(List lines, 1 state, int idx) {
        String line = (String)lines.get(idx - 1);
        if (line.matches(RUST_EMPTY_OR_SINGLE_LINE_COMMENT)) {
            return false;
        }
        if (idx == 1 && line.matches(RUST_SHEBANG)) {
            return false;
        }
        if (line.matches(RUST_MULTILINE_COMMENT_BEGIN)) {
            state.insideMultilineComment = true;
            return false;
        }
        if (state.insideMultilineComment && line.matches(RUST_MULTILINE_COMMENT_END)) {
            state.insideMultilineComment = false;
            return false;
        }
        return !state.insideMultilineComment;
    }
}

