/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rust;

import de.jplag.rust.ParserState;
import de.jplag.rust.RustParserAdapter;
import de.jplag.rust.RustTokenType;
import de.jplag.rust.grammar.RustParser;
import de.jplag.rust.grammar.RustParserBaseListener;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class JPlagRustListener
extends RustParserBaseListener
implements ParseTreeListener {
    private final RustParserAdapter parserAdapter;
    private final ParserState<RustContext> state = new ParserState();

    public JPlagRustListener(RustParserAdapter parserAdapter) {
        this.parserAdapter = parserAdapter;
        this.state.enter(RustContext.FILE);
    }

    private void transformToken(Optional<RustTokenType> targetType, Token token) {
        targetType.ifPresent(type -> this.transformToken((RustTokenType)((Object)type), token));
    }

    private void transformToken(RustTokenType targetType, Token token) {
        this.parserAdapter.addToken(targetType, token.getLine(), token.getCharPositionInLine() + 1, token.getText().length());
    }

    private void transformToken(RustTokenType targetType, Token start, Token end) {
        this.parserAdapter.addToken(targetType, start.getLine(), start.getCharPositionInLine() + 1, end.getStopIndex() - start.getStartIndex() + 1);
    }

    @Override
    public void enterInnerAttribute(RustParser.InnerAttributeContext context) {
        this.transformToken(RustTokenType.INNER_ATTRIBUTE, context.getStart(), context.getStop());
        super.enterInnerAttribute(context);
    }

    @Override
    public void enterOuterAttribute(RustParser.OuterAttributeContext context) {
        this.transformToken(RustTokenType.OUTER_ATTRIBUTE, context.getStart(), context.getStop());
        super.enterOuterAttribute(context);
    }

    @Override
    public void enterUseDeclaration(RustParser.UseDeclarationContext context) {
        this.transformToken(RustTokenType.USE_DECLARATION, context.getStart());
        super.enterUseDeclaration(context);
    }

    @Override
    public void enterUseTree(RustParser.UseTreeContext context) {
        this.state.enter(RustContext.USE_TREE);
        super.enterUseTree(context);
    }

    @Override
    public void exitUseTree(RustParser.UseTreeContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.USE_TREE});
        super.exitUseTree(context);
    }

    @Override
    public void enterSimplePath(RustParser.SimplePathContext context) {
        if (this.state.getCurrentContext() == RustContext.USE_TREE) {
            if (context.parent.getChildCount() > 1 && context.parent.getChild(1).getText().equals("::")) {
                return;
            }
            this.transformToken(RustTokenType.USE_ITEM, context.getStart(), context.getStop());
        }
        super.enterSimplePath(context);
    }

    @Override
    public void enterModule(RustParser.ModuleContext context) {
        this.transformToken(RustTokenType.MODULE, context.getStart());
        this.state.enter(RustContext.MODULE_BODY);
        super.enterModule(context);
    }

    @Override
    public void enterStruct_(RustParser.Struct_Context context) {
        this.transformToken(RustTokenType.STRUCT, context.getStart());
        this.state.enter(RustContext.STRUCT_DECLARATION_BODY);
        super.enterStruct_(context);
    }

    @Override
    public void exitStruct_(RustParser.Struct_Context context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.STRUCT_DECLARATION_BODY});
        super.exitStruct_(context);
    }

    @Override
    public void enterStructExpression(RustParser.StructExpressionContext context) {
        this.transformToken(RustTokenType.STRUCT_INITIALISATION, context.getStart());
        this.state.enter(RustContext.STRUCT_INITIALISATION);
        super.enterStructExpression(context);
    }

    @Override
    public void exitStructExpression(RustParser.StructExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.STRUCT_INITIALISATION});
        super.exitStructExpression(context);
    }

    @Override
    public void enterStructField(RustParser.StructFieldContext context) {
        this.transformToken(RustTokenType.STRUCT_FIELD, context.getStart());
        super.enterStructField(context);
    }

    @Override
    public void enterStructExprField(RustParser.StructExprFieldContext context) {
        this.transformToken(RustTokenType.ARGUMENT, context.getStart(), context.getStop());
        super.enterStructExprField(context);
    }

    @Override
    public void enterStructPattern(RustParser.StructPatternContext context) {
        this.transformToken(RustTokenType.STRUCT, context.getStart());
        this.state.enter(RustContext.STRUCT_DECLARATION_BODY);
        super.enterStructPattern(context);
    }

    @Override
    public void exitStructPattern(RustParser.StructPatternContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.STRUCT_DECLARATION_BODY});
        super.exitStructPattern(context);
    }

    @Override
    public void enterStructPatternField(RustParser.StructPatternFieldContext context) {
        this.transformToken(RustTokenType.STRUCT_FIELD, context.getStart());
        super.enterStructPatternField(context);
    }

    @Override
    public void enterTupleExpression(RustParser.TupleExpressionContext context) {
        this.state.enter(RustContext.TUPLE);
        RustParser.TupleElementsContext elements = (RustParser.TupleElementsContext)context.getChild(RustParser.TupleElementsContext.class, 0);
        if (Objects.nonNull((Object)elements) && elements.getChildCount() == 1) {
            this.state.enter(RustContext.REDUNDANT_TUPLE);
        }
        super.enterTupleExpression(context);
    }

    @Override
    public void exitTupleExpression(RustParser.TupleExpressionContext ctx) {
        this.state.leaveIfInContext(RustContext.REDUNDANT_TUPLE);
        this.state.leaveAsserted(new RustContext[]{RustContext.TUPLE});
        super.exitTupleExpression(ctx);
    }

    @Override
    public void enterTupleField(RustParser.TupleFieldContext context) {
        if (this.state.getCurrentContext() != RustContext.REDUNDANT_TUPLE) {
            this.transformToken(RustTokenType.TUPLE_ELEMENT, context.getStart());
        }
        super.enterTupleField(context);
    }

    @Override
    public void enterTupleStructPattern(RustParser.TupleStructPatternContext context) {
        this.transformToken(RustTokenType.STRUCT_INITIALISATION, context.getStart());
        this.state.enter(RustContext.STRUCT_INITIALISATION);
        super.enterTupleStructPattern(context);
    }

    @Override
    public void exitTupleStructPattern(RustParser.TupleStructPatternContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.STRUCT_INITIALISATION});
        super.exitTupleStructPattern(context);
    }

    @Override
    public void enterTupleStructItems(RustParser.TupleStructItemsContext context) {
        this.state.enter(RustContext.TUPLE_STRUCT_PATTERN);
        super.enterTupleStructItems(context);
    }

    @Override
    public void exitTupleStructItems(RustParser.TupleStructItemsContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TUPLE_STRUCT_PATTERN});
        super.exitTupleStructItems(context);
    }

    @Override
    public void enterTuplePatternItems(RustParser.TuplePatternItemsContext context) {
        this.state.enter(RustContext.TUPLE_PATTERN);
        super.enterTuplePatternItems(context);
    }

    @Override
    public void exitTuplePatternItems(RustParser.TuplePatternItemsContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TUPLE_PATTERN});
        super.exitTuplePatternItems(context);
    }

    @Override
    public void enterUnion_(RustParser.Union_Context context) {
        this.transformToken(RustTokenType.UNION, context.getStart());
        this.state.enter(RustContext.UNION_BODY);
        super.enterUnion_(context);
    }

    @Override
    public void exitUnion_(RustParser.Union_Context context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.UNION_BODY});
        super.exitUnion_(context);
    }

    @Override
    public void enterTrait_(RustParser.Trait_Context context) {
        this.transformToken(RustTokenType.TRAIT, context.getStart());
        this.state.enter(RustContext.TRAIT_BODY);
        super.enterTrait_(context);
    }

    @Override
    public void exitTrait_(RustParser.Trait_Context context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TRAIT_BODY});
        super.exitTrait_(context);
    }

    @Override
    public void enterTypeAlias(RustParser.TypeAliasContext context) {
        this.transformToken(RustTokenType.TYPE_ALIAS, context.getStart());
        super.enterTypeAlias(context);
    }

    @Override
    public void enterImplementation(RustParser.ImplementationContext context) {
        this.transformToken(RustTokenType.IMPLEMENTATION, context.getStart());
        this.state.enter(RustContext.IMPLEMENTATION_BODY);
        super.enterImplementation(context);
    }

    @Override
    public void exitImplementation(RustParser.ImplementationContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.IMPLEMENTATION_BODY});
        super.exitImplementation(context);
    }

    @Override
    public void enterEnumeration(RustParser.EnumerationContext context) {
        this.transformToken(RustTokenType.ENUM, context.getStart());
        this.state.enter(RustContext.ENUM_BODY);
        super.enterEnumeration(context);
    }

    @Override
    public void exitEnumeration(RustParser.EnumerationContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.ENUM_BODY});
        super.exitEnumeration(context);
    }

    @Override
    public void enterEnumItemTuple(RustParser.EnumItemTupleContext ctx) {
        this.state.enter(RustContext.TUPLE);
        super.enterEnumItemTuple(ctx);
    }

    @Override
    public void exitEnumItemTuple(RustParser.EnumItemTupleContext ctx) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TUPLE});
        super.exitEnumItemTuple(ctx);
    }

    @Override
    public void enterEnumItem(RustParser.EnumItemContext context) {
        this.transformToken(RustTokenType.ENUM_ITEM, context.getStart());
        super.enterEnumItem(context);
    }

    @Override
    public void enterMacroRulesDefinition(RustParser.MacroRulesDefinitionContext context) {
        this.transformToken(RustTokenType.MACRO_RULES_DEFINITION, context.getStart());
        this.state.enter(RustContext.MACRO_RULES_DEFINITION_BODY);
        super.enterMacroRulesDefinition(context);
    }

    @Override
    public void exitMacroRulesDefinition(RustParser.MacroRulesDefinitionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_RULES_DEFINITION_BODY});
        super.exitMacroRulesDefinition(context);
    }

    @Override
    public void enterMacroRule(RustParser.MacroRuleContext context) {
        this.transformToken(RustTokenType.MACRO_RULE, context.getStart());
        this.state.enter(RustContext.MACRO_RULE_BODY);
        super.enterMacroRule(context);
    }

    @Override
    public void exitMacroRule(RustParser.MacroRuleContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_RULE_BODY});
        super.exitMacroRule(context);
    }

    @Override
    public void enterMacroInvocationSemi(RustParser.MacroInvocationSemiContext context) {
        this.transformToken(RustTokenType.MACRO_INVOCATION, context.getStart());
        this.state.enter(RustContext.MACRO_INVOCATION_BODY);
        super.enterMacroInvocationSemi(context);
    }

    @Override
    public void exitMacroInvocationSemi(RustParser.MacroInvocationSemiContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_INVOCATION_BODY});
        super.exitMacroInvocationSemi(context);
    }

    @Override
    public void enterMacroInvocation(RustParser.MacroInvocationContext context) {
        this.transformToken(RustTokenType.MACRO_INVOCATION, context.getStart());
        this.state.enter(RustContext.MACRO_INVOCATION_BODY);
        super.enterMacroInvocation(context);
    }

    @Override
    public void exitMacroInvocation(RustParser.MacroInvocationContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_INVOCATION_BODY});
        super.exitMacroInvocation(context);
    }

    @Override
    public void enterExternBlock(RustParser.ExternBlockContext context) {
        this.transformToken(RustTokenType.EXTERN_BLOCK, context.getStart());
        this.state.enter(RustContext.EXTERN_BLOCK);
        super.enterExternBlock(context);
    }

    @Override
    public void exitExternBlock(RustParser.ExternBlockContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.EXTERN_BLOCK});
        super.exitExternBlock(context);
    }

    @Override
    public void enterExternCrate(RustParser.ExternCrateContext context) {
        this.transformToken(RustTokenType.EXTERN_CRATE, context.getStart());
        super.enterExternCrate(context);
    }

    @Override
    public void enterStaticItem(RustParser.StaticItemContext context) {
        RustTokenType tokenType = context.getParent() instanceof RustParser.ExternalItemContext ? RustTokenType.STATIC_ITEM : RustTokenType.VARIABLE_DECLARATION;
        this.transformToken(tokenType, context.getStart());
        super.enterStaticItem(context);
    }

    @Override
    public void enterFunction_(RustParser.Function_Context context) {
        Token fn = ((TerminalNodeImpl)context.getChild(TerminalNodeImpl.class, 0)).getSymbol();
        this.transformToken(RustTokenType.FUNCTION, fn);
        boolean hasReturnType = context.getChild(RustParser.FunctionReturnTypeContext.class, 0) != null;
        this.state.enter(hasReturnType ? RustContext.FUNCTION_BODY : RustContext.PROCEDURE_BODY);
        super.enterFunction_(context);
    }

    @Override
    public void exitFunction_(RustParser.Function_Context context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.FUNCTION_BODY, RustContext.PROCEDURE_BODY});
        super.exitFunction_(context);
    }

    @Override
    public void enterSelfParam(RustParser.SelfParamContext context) {
        this.transformToken(RustTokenType.FUNCTION_PARAMETER, context.getStart(), context.getStop());
        super.enterSelfParam(context);
    }

    @Override
    public void enterFunctionParam(RustParser.FunctionParamContext context) {
        this.transformToken(RustTokenType.FUNCTION_PARAMETER, context.getStart(), context.getStop());
        super.enterFunctionParam(context);
    }

    @Override
    public void enterGenericParam(RustParser.GenericParamContext context) {
        if (!(context.getParent().getParent() instanceof RustParser.ForLifetimesContext)) {
            this.transformToken(RustTokenType.TYPE_PARAMETER, context.getStart(), context.getStop());
        }
        super.enterGenericParam(context);
    }

    @Override
    public void enterExpressionWithBlock(RustParser.ExpressionWithBlockContext context) {
        this.state.enter(RustContext.INNER_BLOCK);
        super.enterExpressionWithBlock(context);
    }

    @Override
    public void exitExpressionWithBlock(RustParser.ExpressionWithBlockContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.INNER_BLOCK});
        super.exitExpressionWithBlock(context);
    }

    @Override
    public void enterIfExpression(RustParser.IfExpressionContext context) {
        this.transformToken(RustTokenType.IF_STATEMENT, context.getStart());
        this.state.enter(RustContext.IF_BODY);
        super.enterIfExpression(context);
    }

    @Override
    public void exitIfExpression(RustParser.IfExpressionContext context) {
        this.state.leaveIfInContext(RustContext.ELSE_BODY);
        this.state.leaveAsserted(new RustContext[]{RustContext.IF_BODY, RustContext.ELSE_BODY});
        super.exitIfExpression(context);
    }

    @Override
    public void enterIfLetExpression(RustParser.IfLetExpressionContext ctx) {
        this.transformToken(RustTokenType.IF_STATEMENT, ctx.getStart());
        this.state.enter(RustContext.IF_BODY);
        super.enterIfLetExpression(ctx);
    }

    @Override
    public void exitIfLetExpression(RustParser.IfLetExpressionContext ctx) {
        this.state.leaveIfInContext(RustContext.ELSE_BODY);
        this.state.leaveAsserted(new RustContext[]{RustContext.IF_BODY});
        super.exitIfLetExpression(ctx);
    }

    @Override
    public void enterLoopLabel(RustParser.LoopLabelContext context) {
        this.transformToken(RustTokenType.LABEL, context.getStart());
        super.enterLoopLabel(context);
    }

    @Override
    public void enterInfiniteLoopExpression(RustParser.InfiniteLoopExpressionContext context) {
        Token loopKeyword = ((TerminalNodeImpl)context.getChild(TerminalNodeImpl.class, 0)).getSymbol();
        this.transformToken(RustTokenType.LOOP_STATEMENT, loopKeyword);
        this.state.enter(RustContext.LOOP_BODY);
        super.enterInfiniteLoopExpression(context);
    }

    @Override
    public void exitInfiniteLoopExpression(RustParser.InfiniteLoopExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.LOOP_BODY});
        super.exitInfiniteLoopExpression(context);
    }

    @Override
    public void enterPredicateLoopExpression(RustParser.PredicateLoopExpressionContext context) {
        Token whileKeyword = ((TerminalNodeImpl)context.getChild(TerminalNodeImpl.class, 0)).getSymbol();
        this.transformToken(RustTokenType.LOOP_STATEMENT, whileKeyword);
        this.state.enter(RustContext.LOOP_BODY);
        super.enterPredicateLoopExpression(context);
    }

    @Override
    public void exitPredicateLoopExpression(RustParser.PredicateLoopExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.LOOP_BODY});
        super.exitPredicateLoopExpression(context);
    }

    @Override
    public void enterPredicatePatternLoopExpression(RustParser.PredicatePatternLoopExpressionContext context) {
        Token whileKeyword = ((TerminalNodeImpl)context.getChild(TerminalNodeImpl.class, 0)).getSymbol();
        this.transformToken(RustTokenType.LOOP_STATEMENT, whileKeyword);
        this.state.enter(RustContext.LOOP_BODY);
        super.enterPredicatePatternLoopExpression(context);
    }

    @Override
    public void exitPredicatePatternLoopExpression(RustParser.PredicatePatternLoopExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.LOOP_BODY});
        super.exitPredicatePatternLoopExpression(context);
    }

    @Override
    public void enterIteratorLoopExpression(RustParser.IteratorLoopExpressionContext context) {
        Token forKeyword = ((TerminalNodeImpl)context.getChild(TerminalNodeImpl.class, 0)).getSymbol();
        this.transformToken(RustTokenType.FOR_STATEMENT, forKeyword);
        this.state.enter(RustContext.FOR_BODY);
        super.enterIteratorLoopExpression(context);
    }

    @Override
    public void exitIteratorLoopExpression(RustParser.IteratorLoopExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.FOR_BODY});
        super.exitIteratorLoopExpression(context);
    }

    @Override
    public void enterBreakExpression(RustParser.BreakExpressionContext context) {
        this.transformToken(RustTokenType.BREAK, context.getStart());
        super.enterBreakExpression(context);
    }

    @Override
    public void enterMatchExpression(RustParser.MatchExpressionContext context) {
        this.transformToken(RustTokenType.MATCH_EXPRESSION, context.getStart());
        this.state.enter(RustContext.MATCH_BODY);
        super.enterMatchExpression(context);
    }

    @Override
    public void exitMatchExpression(RustParser.MatchExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.MATCH_BODY});
        super.exitMatchExpression(context);
    }

    @Override
    public void enterMatchArm(RustParser.MatchArmContext context) {
        this.transformToken(RustTokenType.MATCH_CASE, context.getStart());
        super.enterMatchArm(context);
    }

    @Override
    public void enterMatchArmGuard(RustParser.MatchArmGuardContext context) {
        this.transformToken(RustTokenType.MATCH_GUARD, context.getStart());
        super.enterMatchArmGuard(context);
    }

    @Override
    public void enterCompoundAssignOperator(RustParser.CompoundAssignOperatorContext context) {
        this.transformToken(RustTokenType.ASSIGNMENT, context.getStart());
        super.enterCompoundAssignOperator(context);
    }

    @Override
    public void enterCallExpression(RustParser.CallExpressionContext ctx) {
        this.state.enter(RustContext.CALL);
        super.enterCallExpression(ctx);
    }

    @Override
    public void exitCallExpression(RustParser.CallExpressionContext ctx) {
        this.state.leaveAsserted(new RustContext[]{RustContext.CALL});
        super.exitCallExpression(ctx);
    }

    @Override
    public void enterMethodCallExpression(RustParser.MethodCallExpressionContext context) {
        this.state.enter(RustContext.CALL);
        super.enterMethodCallExpression(context);
    }

    @Override
    public void exitMethodCallExpression(RustParser.MethodCallExpressionContext ctx) {
        this.state.leaveAsserted(new RustContext[]{RustContext.CALL});
        super.exitMethodCallExpression(ctx);
    }

    @Override
    public void enterConstantItem(RustParser.ConstantItemContext context) {
        this.transformToken(RustTokenType.VARIABLE_DECLARATION, context.getStart());
        super.enterConstantItem(context);
    }

    @Override
    public void enterArrayExpression(RustParser.ArrayExpressionContext context) {
        this.transformToken(RustTokenType.ARRAY_BODY_START, context.getStart());
        super.enterArrayExpression(context);
    }

    @Override
    public void exitArrayExpression(RustParser.ArrayExpressionContext context) {
        this.transformToken(RustTokenType.ARRAY_BODY_END, context.getStop());
        super.exitArrayExpression(context);
    }

    @Override
    public void enterTuplePattern(RustParser.TuplePatternContext context) {
        this.transformToken(RustTokenType.TUPLE, context.getStart());
        this.state.enter(RustContext.TUPLE);
        super.enterTuplePattern(context);
    }

    @Override
    public void exitTuplePattern(RustParser.TuplePatternContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TUPLE});
        super.exitTuplePattern(context);
    }

    @Override
    public void enterClosureExpression(RustParser.ClosureExpressionContext context) {
        this.transformToken(RustTokenType.CLOSURE, context.getStart());
        this.state.enter(RustContext.CLOSURE_BODY);
        super.enterClosureExpression(context);
    }

    @Override
    public void exitClosureExpression(RustParser.ClosureExpressionContext context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.CLOSURE_BODY});
        super.exitClosureExpression(context);
    }

    @Override
    public void enterClosureParam(RustParser.ClosureParamContext context) {
        this.transformToken(RustTokenType.FUNCTION_PARAMETER, context.getStart());
        super.enterClosureParam(context);
    }

    @Override
    public void enterReturnExpression(RustParser.ReturnExpressionContext context) {
        this.transformToken(RustTokenType.RETURN, context.getStart());
        super.enterReturnExpression(context);
    }

    @Override
    public void enterExpressionStatement(RustParser.ExpressionStatementContext context) {
        boolean isImplicitReturnValue;
        RuleContext maybeFunctionBlock = context.parent.parent;
        boolean bl = isImplicitReturnValue = maybeFunctionBlock instanceof RustParser.StatementsContext && maybeFunctionBlock.getChildCount() == 1 && this.state.getCurrentContext() == RustContext.FUNCTION_BODY && !(context.getChild(0) instanceof RustParser.ReturnExpressionContext);
        if (isImplicitReturnValue) {
            this.transformToken(RustTokenType.RETURN, context.getStart());
        }
        super.enterExpressionStatement(context);
    }

    @Override
    public void enterPattern(RustParser.PatternContext context) {
        switch (this.state.getCurrentContext()) {
            case TUPLE_STRUCT_PATTERN: {
                this.transformToken(RustTokenType.ARGUMENT, context.getStart(), context.getStop());
                break;
            }
            case TUPLE_PATTERN: {
                this.transformToken(RustTokenType.TUPLE_ELEMENT, context.getStart());
                break;
            }
        }
        super.enterPattern(context);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token token = node.getSymbol();
        ParseTree parentNode = node.getParent();
        RustContext stateContext = this.state.getCurrentContext();
        block12 : switch (node.getText()) {
            case "*": {
                if (!(parentNode instanceof RustParser.UseTreeContext)) break;
                this.transformToken(RustTokenType.USE_ITEM, token);
                break;
            }
            case "let": {
                if (stateContext == RustContext.MACRO_INNER) break;
                this.transformToken(RustTokenType.VARIABLE_DECLARATION, token);
                break;
            }
            case "=": {
                if (parentNode instanceof RustParser.AttrInputContext || parentNode instanceof RustParser.MacroPunctuationTokenContext || parentNode instanceof RustParser.TypeParamContext || parentNode instanceof RustParser.GenericArgsBindingContext || stateContext == RustContext.MACRO_INNER) break;
                this.transformToken(RustTokenType.ASSIGNMENT, token);
                break;
            }
            case "{": {
                Optional<RustTokenType> startType = stateContext.getStartType();
                startType.ifPresent(type -> this.transformToken((RustTokenType)((Object)type), token));
                switch (stateContext) {
                    case MACRO_RULE_BODY: 
                    case MACRO_INVOCATION_BODY: 
                    case MACRO_INNER: {
                        this.state.enter(RustContext.MACRO_INNER);
                        break block12;
                    }
                }
                break;
            }
            case "}": {
                Optional<RustTokenType> endType = stateContext.getEndType();
                endType.ifPresent(type -> this.transformToken((RustTokenType)((Object)type), token));
                if (stateContext != RustContext.MACRO_INNER) break;
                this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_INNER});
                stateContext = this.state.getCurrentContext();
                if (stateContext != RustContext.MACRO_INVOCATION_BODY && stateContext != RustContext.MACRO_RULE_BODY) break;
                this.transformToken(stateContext.getEndType(), token);
                break;
            }
            case "(": {
                switch (stateContext) {
                    case STRUCT_DECLARATION_BODY: {
                        this.transformToken(RustContext.STRUCT_DECLARATION_BODY.getStartType(), token);
                        break block12;
                    }
                    case TUPLE: {
                        this.transformToken(RustContext.TUPLE.getStartType(), token);
                        break block12;
                    }
                    case MACRO_INVOCATION_BODY: {
                        this.transformToken(RustTokenType.MACRO_INVOCATION_BODY_START, token);
                        this.state.enter(RustContext.MACRO_INNER);
                        break block12;
                    }
                    case MACRO_INNER: {
                        this.state.enter(RustContext.MACRO_INNER);
                        break block12;
                    }
                    case CALL: {
                        this.transformToken(RustTokenType.APPLY, token);
                        break block12;
                    }
                }
                break;
            }
            case ")": 
            case "]": {
                switch (stateContext) {
                    case STRUCT_DECLARATION_BODY: {
                        this.transformToken(RustContext.STRUCT_DECLARATION_BODY.getEndType(), token);
                        break block12;
                    }
                    case TUPLE: {
                        this.transformToken(RustContext.TUPLE.getEndType(), token);
                        break block12;
                    }
                    case MACRO_INVOCATION_BODY: {
                        break block12;
                    }
                    case MACRO_INNER: {
                        this.state.leaveAsserted(new RustContext[]{RustContext.MACRO_INNER});
                        stateContext = this.state.getCurrentContext();
                        if (stateContext != RustContext.MACRO_INVOCATION_BODY) break block12;
                        this.transformToken(RustTokenType.MACRO_INVOCATION_BODY_END, token);
                        break block12;
                    }
                }
                break;
            }
            case "[": {
                switch (stateContext) {
                    case MACRO_INVOCATION_BODY: {
                        this.transformToken(RustTokenType.MACRO_INVOCATION_BODY_START, token);
                        this.state.enter(RustContext.MACRO_INNER);
                        break block12;
                    }
                    case MACRO_INNER: {
                        this.state.enter(RustContext.MACRO_INNER);
                        break block12;
                    }
                }
                break;
            }
            case "else": {
                if (stateContext != RustContext.IF_BODY) break;
                this.transformToken(RustTokenType.ELSE_STATEMENT, token);
                this.state.enter(RustContext.ELSE_BODY);
                break;
            }
        }
    }

    @Override
    public void enterType_(RustParser.Type_Context context) {
        if (context.getParent() instanceof RustParser.GenericArgsTypesContext && context.getParent().getParent().getParent() instanceof RustParser.PathExprSegmentContext) {
            this.transformToken(RustTokenType.TYPE_ARGUMENT, context.getStart(), context.getStop());
        }
        this.state.enter(RustContext.TYPE);
        super.enterType_(context);
    }

    @Override
    public void exitType_(RustParser.Type_Context context) {
        this.state.leaveAsserted(new RustContext[]{RustContext.TYPE});
        super.exitType_(context);
    }

    @Override
    public void enterGenericArg(RustParser.GenericArgContext context) {
        if (context.getParent().getParent() instanceof RustParser.PathInExpressionContext) {
            this.transformToken(RustTokenType.TYPE_ARGUMENT, context.getStart(), context.getStop());
        }
        super.enterGenericArg(context);
    }

    @Override
    public void enterEveryRule(ParserRuleContext context) {
        if (context instanceof RustParser.ExpressionContext) {
            RustParser.ExpressionContext expression = (RustParser.ExpressionContext)context;
            if (context.parent instanceof RustParser.ArrayElementsContext) {
                this.transformToken(RustTokenType.ARRAY_ELEMENT, expression.getStart());
            } else if (context.parent instanceof RustParser.CallParamsContext) {
                this.transformToken(RustTokenType.ARGUMENT, expression.getStart(), expression.getStop());
            } else if (context.parent instanceof RustParser.TuplePatternItemsContext || context.parent instanceof RustParser.TupleElementsContext) {
                if (this.state.getCurrentContext() == RustContext.REDUNDANT_TUPLE) {
                    return;
                }
                this.transformToken(RustTokenType.TUPLE_ELEMENT, expression.getStart());
            } else if (context.parent instanceof RustParser.ClosureExpressionContext) {
                this.transformToken(RustTokenType.CLOSURE_BODY_START, context.getStart());
                this.transformToken(RustTokenType.RETURN, expression.getStart());
            }
        }
    }

    @Override
    public void exitEveryRule(ParserRuleContext context) {
        if (context instanceof RustParser.ExpressionContext && context.parent instanceof RustParser.ClosureExpressionContext) {
            this.transformToken(RustTokenType.CLOSURE_BODY_END, context.getStop());
        }
    }

    static enum RustContext implements ParserState.Context
    {
        FILE,
        FUNCTION_BODY(RustTokenType.FUNCTION_BODY_START, RustTokenType.FUNCTION_BODY_END),
        PROCEDURE_BODY(RustTokenType.FUNCTION_BODY_START, RustTokenType.FUNCTION_BODY_END),
        STRUCT_DECLARATION_BODY(RustTokenType.STRUCT_BODY_START, RustTokenType.STRUCT_BODY_END),
        IF_BODY(RustTokenType.IF_BODY_START, RustTokenType.IF_BODY_END),
        ELSE_BODY(RustTokenType.ELSE_BODY_START, RustTokenType.ELSE_BODY_END),
        LOOP_BODY(RustTokenType.LOOP_BODY_START, RustTokenType.LOOP_BODY_END),
        INNER_BLOCK(RustTokenType.INNER_BLOCK_START, RustTokenType.INNER_BLOCK_END),
        TRAIT_BODY(RustTokenType.TRAIT_BODY_START, RustTokenType.TRAIT_BODY_END),
        ENUM_BODY(RustTokenType.ENUM_BODY_START, RustTokenType.ENUM_BODY_END),
        MACRO_RULES_DEFINITION_BODY(RustTokenType.MACRO_RULES_DEFINITION_BODY_START, RustTokenType.MACRO_RULES_DEFINITION_BODY_END),
        MACRO_RULE_BODY(RustTokenType.MACRO_RULE_BODY_START, RustTokenType.MACRO_RULE_BODY_END),
        MACRO_INVOCATION_BODY(RustTokenType.MACRO_INVOCATION_BODY_START, RustTokenType.MACRO_INVOCATION_BODY_END),
        IMPLEMENTATION_BODY(RustTokenType.IMPLEMENTATION_BODY_START, RustTokenType.IMPLEMENTATION_BODY_END),
        EXTERN_BLOCK(RustTokenType.EXTERN_BLOCK_START, RustTokenType.EXTERN_BLOCK_END),
        MODULE_BODY(RustTokenType.MODULE_START, RustTokenType.MODULE_END),
        UNION_BODY(RustTokenType.UNION_BODY_START, RustTokenType.UNION_BODY_END),
        CLOSURE_BODY(RustTokenType.CLOSURE_BODY_START, RustTokenType.CLOSURE_BODY_END),
        MATCH_BODY(RustTokenType.MATCH_BODY_START, RustTokenType.MATCH_BODY_END),
        FOR_BODY(RustTokenType.FOR_BODY_START, RustTokenType.FOR_BODY_END),
        TUPLE(RustTokenType.TUPLE_START, RustTokenType.TUPLE_END),
        TYPE,
        TUPLE_STRUCT_PATTERN,
        TUPLE_PATTERN,
        REDUNDANT_TUPLE,
        MACRO_INNER,
        USE_TREE,
        CALL,
        STRUCT_INITIALISATION;

        private final Optional<RustTokenType> startType;
        private final Optional<RustTokenType> endType;

        private RustContext() {
            this.startType = Optional.empty();
            this.endType = Optional.empty();
        }

        private RustContext(RustTokenType startType, RustTokenType endType) {
            this.startType = Optional.of(startType);
            this.endType = Optional.of(endType);
        }

        @Override
        public Optional<RustTokenType> getStartType() {
            return this.startType;
        }

        @Override
        public Optional<RustTokenType> getEndType() {
            return this.endType;
        }
    }
}

