/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rlang;

import de.jplag.TokenType;
import de.jplag.antlr.AbstractAntlrListener;
import de.jplag.rlang.RTokenType;
import de.jplag.rlang.grammar.RParser;

public class RListener
extends AbstractAntlrListener {
    public RListener() {
        this.addHeaderRules();
        this.addFunctionRules();
        this.addLiteralRules();
        this.addControlStructureRules();
        this.addAssigmentRules();
    }

    private void addHeaderRules() {
        this.visit(RParser.ArrayAccessContext.class).mapRange((TokenType)RTokenType.INDEX);
        this.visit(RParser.ListAccessContext.class).mapRange((TokenType)RTokenType.INDEX);
        this.visit(RParser.NamespaceAccessContext.class).map((TokenType)RTokenType.PACKAGE);
    }

    private void addFunctionRules() {
        this.visit(RParser.FunctionDefinitionContext.class).map((TokenType)RTokenType.BEGIN_FUNCTION, (TokenType)RTokenType.END_FUNCTION);
        this.visit(RParser.FunctionCallContext.class).mapRange((TokenType)RTokenType.FUNCTION_CALL);
        this.visit(RParser.CompoundStatementContext.class).map((TokenType)RTokenType.COMPOUND_BEGIN, (TokenType)RTokenType.COMPOUND_END);
        this.visit(RParser.HelpContext.class).map((TokenType)RTokenType.HELP);
    }

    private void addLiteralRules() {
        this.visit(RParser.HexContext.class).map((TokenType)RTokenType.NUMBER);
        this.visit(RParser.IntContext.class).map((TokenType)RTokenType.NUMBER);
        this.visit(RParser.FloatContext.class).map((TokenType)RTokenType.NUMBER);
        this.visit(RParser.ComplexContext.class).map((TokenType)RTokenType.NUMBER);
        this.visit(RParser.StringContext.class).map((TokenType)RTokenType.STRING);
        this.visit(RParser.TrueContext.class).map((TokenType)RTokenType.BOOL);
        this.visit(RParser.FalseContext.class).map((TokenType)RTokenType.BOOL);
    }

    private void addControlStructureRules() {
        this.visit(RParser.IfContext.class).map((TokenType)RTokenType.IF_BEGIN, (TokenType)RTokenType.IF_END);
        this.visit(RParser.IfElseContext.class).map((TokenType)RTokenType.IF_BEGIN, (TokenType)RTokenType.IF_END);
        this.visit(RParser.ForContext.class).map((TokenType)RTokenType.FOR_BEGIN, (TokenType)RTokenType.FOR_END);
        this.visit(RParser.WhileContext.class).map((TokenType)RTokenType.WHILE_BEGIN, (TokenType)RTokenType.WHILE_END);
        this.visit(RParser.RepeatContext.class).map((TokenType)RTokenType.REPEAT_BEGIN, (TokenType)RTokenType.REPEAT_END);
        this.visit(RParser.NextContext.class).map((TokenType)RTokenType.NEXT);
        this.visit(RParser.BreakContext.class).map((TokenType)RTokenType.BREAK);
    }

    private void addAssigmentRules() {
        this.visit(RParser.AssignmentContext.class, context -> context.ASSIGN() != null).map((TokenType)RTokenType.ASSIGN);
        this.visit(RParser.AssignmentContext.class, context -> context.EQUALS() != null).map((TokenType)RTokenType.ASSIGN_FUNC);
        this.visit(RParser.SubContext.class).map((TokenType)RTokenType.ASSIGN_LIST);
    }
}

