/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rlang;

import de.jplag.ParsingException;
import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.rlang.RLanguage;
import de.jplag.rlang.RTokenType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RLanguageTest {
    private static final String R_NO_CODE_LINE = "\\s*(?:#.*)?";
    private static final String COMPLETE_TEST_FILE = "Complete.R";
    private final Logger logger = LoggerFactory.getLogger(RLanguageTest.class);
    private final String[] testFiles = new String[]{"Game.R", "Complete.R"};
    private final File testFileLocation = Path.of("src", "test", "resources", "de", "jplag", "rlang").toFile();
    private RLanguage language;

    RLanguageTest() {
    }

    @BeforeEach
    void setup() {
        this.language = new RLanguage();
    }

    @Test
    void parseTestFiles() throws ParsingException {
        for (String fileName : this.testFiles) {
            List tokens = this.language.parse(Set.of(new File(this.testFileLocation, fileName)), false);
            String output = TokenPrinter.printTokens((List)tokens, (File)this.testFileLocation);
            this.logger.info(output);
            this.testSourceCoverage(fileName, tokens);
            if (!COMPLETE_TEST_FILE.equals(fileName)) continue;
            this.testTokenCoverage(tokens, fileName);
        }
    }

    private void testSourceCoverage(String fileName, List<Token> tokens) {
        File testFile = new File(this.testFileLocation, fileName);
        try {
            List<String> lines = Files.readAllLines(testFile.toPath());
            String emptyLineExpression = RLanguageTest.getNoCodeLineExpression();
            int[] codeLines = IntStream.range(1, lines.size() + 1).filter(idx -> !((String)lines.get(idx - 1)).matches(emptyLineExpression)).toArray();
            int[] tokenLines = tokens.stream().mapToInt(Token::getStartLine).filter(line -> line != -1).distinct().toArray();
            if (codeLines.length > tokenLines.length) {
                OptionalInt diffLine = IntStream.range(0, codeLines.length).dropWhile(lineIndex -> lineIndex < tokenLines.length && codeLines[lineIndex] == tokenLines[lineIndex]).findFirst();
                diffLine.ifPresent(lineIdx -> Assertions.fail((String)"Line %d of file '%s' is not represented in the token list.".formatted(codeLines[lineIdx], fileName)));
            }
            Assertions.assertArrayEquals((int[])codeLines, (int[])tokenLines);
        }
        catch (IOException exception) {
            this.logger.info("Error while reading test file %s".formatted(fileName), (Throwable)exception);
            Assertions.fail();
        }
    }

    private void testTokenCoverage(List<Token> tokens, String fileName) {
        Set annotatedTokens = tokens.stream().map(Token::getType).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)annotatedTokens.contains(SharedTokenType.FILE_END));
        Set annotatedRTokens = annotatedTokens.stream().filter(RTokenType.class::isInstance).collect(Collectors.toSet());
        RTokenType[] allRTokens = RTokenType.values();
        List<RTokenType> missingRTokens = Arrays.stream(allRTokens).filter(token -> !annotatedRTokens.contains(token)).toList();
        Assertions.assertTrue((boolean)missingRTokens.isEmpty(), (String)("The following R tokens are missing in the code example '%s':\n".formatted(fileName) + String.join((CharSequence)"\n", missingRTokens.stream().map(RTokenType::getDescription).toList())));
    }

    private static String getNoCodeLineExpression() {
        return R_NO_CODE_LINE;
    }
}

