/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rlang;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.rlang.JPlagRListener;
import de.jplag.rlang.grammar.RFilter;
import de.jplag.rlang.grammar.RLexer;
import de.jplag.rlang.grammar.RParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class RParserAdapter
extends AbstractParser {
    private File currentFile;
    private List<Token> tokens;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.parseFile(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parseFile(File file) throws ParsingException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.currentFile = file;
            RLexer lexer = new RLexer(CharStreams.fromStream((InputStream)inputStream));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            RFilter filter = new RFilter((TokenStream)tokens);
            filter.stream();
            tokens.seek(0);
            RParser parser = new RParser((TokenStream)tokens);
            RParser.ProgContext entryContext = parser.prog();
            ParseTreeWalker treeWalker = new ParseTreeWalker();
            for (int i = 0; i < entryContext.getChildCount(); ++i) {
                ParseTree parseTree = entryContext.getChild(i);
                treeWalker.walk((ParseTreeListener)new JPlagRListener(this), parseTree);
            }
        }
        catch (IOException exception) {
            throw new ParsingException(file, exception.getMessage(), (Throwable)exception);
        }
    }

    void addToken(TokenType type, int line, int start, int length) {
        this.tokens.add(new Token(type, this.currentFile, line, start, length));
    }
}

