/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.llvmir;

import de.jplag.Language;
import de.jplag.TokenType;
import de.jplag.llvmir.LLVMIRLanguage;
import de.jplag.llvmir.LLVMIRTokenType;
import de.jplag.testutils.LanguageModuleTest;
import de.jplag.testutils.datacollector.TestDataCollector;
import de.jplag.testutils.datacollector.TestSourceIgnoredLinesCollector;
import java.util.Arrays;
import java.util.List;

class LLVMIRLanguageTest
extends LanguageModuleTest {
    public LLVMIRLanguageTest() {
        super((Language)new LLVMIRLanguage(), LLVMIRTokenType.class);
    }

    protected void collectTestData(TestDataCollector collector) {
        List<LLVMIRTokenType> missingTokens = List.of(LLVMIRTokenType.CATCH_SWITCH, LLVMIRTokenType.CATCH_RETURN, LLVMIRTokenType.CLEAN_UP_RETURN, LLVMIRTokenType.CATCH_PAD, LLVMIRTokenType.CLEAN_UP_PAD);
        LLVMIRTokenType[] expectedTokens = (LLVMIRTokenType[])Arrays.stream(LLVMIRTokenType.values()).filter(it -> !missingTokens.contains(it)).toArray(LLVMIRTokenType[]::new);
        collector.testFile(new String[]{"Complete.ll"}).testSourceCoverage().testContainedTokens((TokenType[])expectedTokens);
        collector.testFile(new String[]{"NewExceptionHandling.ll"}).testSourceCoverage().testContainedTokens(new TokenType[]{LLVMIRTokenType.CATCH_SWITCH, LLVMIRTokenType.CATCH_RETURN, LLVMIRTokenType.CLEAN_UP_RETURN, LLVMIRTokenType.CATCH_PAD, LLVMIRTokenType.CLEAN_UP_PAD});
    }

    protected void configureIgnoredLines(TestSourceIgnoredLinesCollector collector) {
        collector.ignoreLinesByPrefix(";");
        collector.ignoreLinesByPrefix("target datalayout");
        collector.ignoreLinesByPrefix("target triple");
        collector.ignoreLinesByPrefix("unreachable");
    }
}

