/*
 * Decompiled with CFR 0.152.
 */
package de.jplag;

import de.jplag.SharedTokenType;
import de.jplag.TokenTrace;
import de.jplag.TokenType;
import de.jplag.semantics.CodeSemantics;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Token {
    public static final int NO_VALUE = -1;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int line;
    private final int column;
    private final int length;
    private final File file;
    private final TokenType type;
    private CodeSemantics semantics;

    public Token(TokenType type, File file, int line, int column, int length) {
        if (line == 0) {
            this.logger.warn("Creating a token with line index 0 while index is 1-based");
        }
        if (column == 0) {
            this.logger.warn("Creating a token with column index 0 while index is 1-based");
        }
        this.type = type;
        this.file = file;
        this.line = line;
        this.column = column;
        this.length = length;
    }

    public Token(TokenType type, File file, TokenTrace trace) {
        this(type, file, trace.line(), trace.column(), trace.length());
    }

    public Token(TokenType type, File file, int line, int column, int length, CodeSemantics semantics) {
        this(type, file, line, column, length);
        this.semantics = semantics;
    }

    public static Token fileEnd(File file) {
        return new Token(SharedTokenType.FILE_END, file, -1, -1, -1);
    }

    public static Token semanticFileEnd(File file) {
        CodeSemantics semantics = CodeSemantics.createControl();
        return new Token(SharedTokenType.FILE_END, file, -1, -1, -1, semantics);
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public int getLength() {
        return this.length;
    }

    public int getLine() {
        return this.line;
    }

    public TokenType getType() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public CodeSemantics getSemantics() {
        return this.semantics;
    }
}

