/*
 * Decompiled with CFR 0.152.
 */
package de.jplag;

import de.jplag.Language;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageLoader {
    private static final Logger logger = LoggerFactory.getLogger(LanguageLoader.class);
    private static Map<String, Language> cachedLanguageInstances = null;

    private LanguageLoader() {
        throw new IllegalAccessError();
    }

    public static synchronized Map<String, Language> getAllAvailableLanguages() {
        if (cachedLanguageInstances != null) {
            return cachedLanguageInstances;
        }
        TreeMap<String, Language> languages = new TreeMap<String, Language>();
        for (Language language : ServiceLoader.load(Language.class)) {
            String languageIdentifier = language.getIdentifier();
            if (languages.containsKey(languageIdentifier)) {
                logger.error("Multiple implementations for a language '{}' are present in the classpath! Skipping ..", (Object)languageIdentifier);
                languages.remove(languageIdentifier);
                continue;
            }
            logger.trace("Loading Language Module '{}'", (Object)language.getName());
            languages.put(languageIdentifier, language);
        }
        logger.debug("Available languages: '{}'", languages.values().stream().map(Language::getName).toList());
        cachedLanguageInstances = Collections.unmodifiableMap(languages);
        return cachedLanguageInstances;
    }

    public static Optional<Language> getLanguage(String identifier) {
        Language language = LanguageLoader.getAllAvailableLanguages().get(identifier);
        if (language == null) {
            logger.warn("Attempt to load Language {} was not successful", (Object)identifier);
        }
        return Optional.ofNullable(language);
    }

    public static Set<String> getAllAvailableLanguageIdentifiers() {
        return new TreeSet<String>(LanguageLoader.getAllAvailableLanguages().keySet());
    }

    public static synchronized void clearCache() {
        cachedLanguageInstances = null;
    }
}

