/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.semantics;

import de.jplag.semantics.PositionSignificance;
import de.jplag.semantics.Variable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CodeSemantics {
    private boolean keep;
    private PositionSignificance positionSignificance;
    private final int bidirectionalBlockDepthChange;
    private final Set<Variable> reads;
    private final Set<Variable> writes;

    private CodeSemantics(boolean keep, PositionSignificance positionSignificance, int bidirectionalBlockDepthChange, Set<Variable> reads, Set<Variable> writes) {
        this.keep = keep;
        this.positionSignificance = positionSignificance;
        this.bidirectionalBlockDepthChange = bidirectionalBlockDepthChange;
        this.reads = reads;
        this.writes = writes;
    }

    private CodeSemantics(boolean keep, PositionSignificance positionSignificance, int bidirectionalBlockDepthChange) {
        this(keep, positionSignificance, bidirectionalBlockDepthChange, new HashSet<Variable>(), new HashSet<Variable>());
    }

    public CodeSemantics() {
        this(false, PositionSignificance.NONE, 0);
    }

    public static CodeSemantics createKeep() {
        return new CodeSemantics(true, PositionSignificance.NONE, 0);
    }

    public static CodeSemantics createCritical() {
        return new CodeSemantics(true, PositionSignificance.PARTIAL, 0);
    }

    public static CodeSemantics createControl() {
        return new CodeSemantics(true, PositionSignificance.FULL, 0);
    }

    public static CodeSemantics createLoopBegin() {
        return new CodeSemantics(true, PositionSignificance.FULL, 1);
    }

    public static CodeSemantics createLoopEnd() {
        return new CodeSemantics(true, PositionSignificance.FULL, -1);
    }

    public boolean keep() {
        return this.keep;
    }

    public void markKeep() {
        this.keep = true;
    }

    public int bidirectionalBlockDepthChange() {
        return this.bidirectionalBlockDepthChange;
    }

    public boolean hasPartialPositionSignificance() {
        return this.positionSignificance == PositionSignificance.PARTIAL;
    }

    public boolean hasFullPositionSignificance() {
        return this.positionSignificance == PositionSignificance.FULL;
    }

    public void markFullPositionSignificance() {
        this.positionSignificance = PositionSignificance.FULL;
    }

    public Set<Variable> reads() {
        return Collections.unmodifiableSet(this.reads);
    }

    public Set<Variable> writes() {
        return Collections.unmodifiableSet(this.writes);
    }

    public void addRead(Variable variable) {
        this.reads.add(variable);
    }

    public void addWrite(Variable variable) {
        this.writes.add(variable);
    }

    public static CodeSemantics join(List<CodeSemantics> semanticsList) {
        boolean keep = false;
        PositionSignificance positionSignificance = PositionSignificance.NONE;
        int bidirectionalBlockDepthChange = 0;
        HashSet<Variable> reads = new HashSet<Variable>();
        HashSet<Variable> writes = new HashSet<Variable>();
        for (CodeSemantics semantics : semanticsList) {
            boolean bl = keep = keep || semantics.keep;
            if (semantics.positionSignificance.compareTo(positionSignificance) > 0) {
                positionSignificance = semantics.positionSignificance;
            }
            bidirectionalBlockDepthChange += semantics.bidirectionalBlockDepthChange();
            reads.addAll(semantics.reads);
            writes.addAll(semantics.writes);
        }
        return new CodeSemantics(keep, positionSignificance, bidirectionalBlockDepthChange, reads, writes);
    }

    public String toString() {
        LinkedList<Object> properties = new LinkedList<Object>();
        if (this.keep) {
            properties.add("keep");
        }
        if (this.positionSignificance != PositionSignificance.NONE) {
            properties.add(this.positionSignificance.name().toLowerCase() + " position significance");
        }
        if (this.bidirectionalBlockDepthChange != 0) {
            properties.add("change bidirectional block depth by " + this.bidirectionalBlockDepthChange);
        }
        if (!this.reads.isEmpty()) {
            properties.add("read " + String.join((CharSequence)" ", this.reads.stream().map(Variable::toString).toList()));
        }
        if (!this.writes.isEmpty()) {
            properties.add("write " + String.join((CharSequence)" ", this.writes.stream().map(Variable::toString).toList()));
        }
        return String.join((CharSequence)", ", properties);
    }
}

