/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.util;

import de.jplag.ParsingException;
import de.jplag.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FileUtilTest {
    private static final Path TEST_FILE_LOCATION = Path.of("src", "test", "resources", "de", "jplag", "fileReaderTests");
    private static final Path TEST_FILE_SET_LOCATION = Path.of("src", "test", "resources", "de", "jplag", "fileSetEncoding");
    private static final String expectedFileContent = "Some ascii characters and some others: \u00e4#+\u00f6\u00fc%&(/)?=?";

    @ParameterizedTest
    @MethodSource(value={"searchTestFiles"})
    void testReadFile(File file) throws IOException {
        String found = FileUtils.readFileContent((File)file);
        Assertions.assertEquals((Object)expectedFileContent, (Object)found, (String)("File contains unexpected content: " + file.getAbsolutePath()));
    }

    @ParameterizedTest
    @MethodSource(value={"searchTestFiles"})
    void testCharsetDetection(File file) throws IOException {
        Assertions.assertEquals((Object)Charset.forName(file.getName()), (Object)FileUtils.detectCharset((File)file), (String)("Wrong charset assumed for: " + file.getAbsolutePath()));
    }

    @Test
    void testDetectFromFileSet() throws ParsingException {
        Set<File> files = Set.of(TEST_FILE_SET_LOCATION.toFile().listFiles());
        Charset encoding = FileUtils.detectCharsetFromMultiple(files);
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1, (Object)encoding);
    }

    public static File[] searchTestFiles() {
        return TEST_FILE_LOCATION.toFile().listFiles();
    }
}

