/*
 * Decompiled with CFR 0.152.
 */
package de.jplag;

import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.TokenType;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenPrinterTest {
    private static final Path TEST_FILE_LOCATION = Path.of("src", "test", "resources", "de", "jplag", "samples");
    private static final String TEST_FILE_NAME = "TokenPrinterTest.txt";
    private static final String TOKEN_SEPARATOR = "(\\|)? *\\|";
    private static final Logger logger = LoggerFactory.getLogger(TokenPrinterTest.class);

    TokenPrinterTest() {
    }

    @Test
    void printMockDirectoriesAsSubmissions() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        File testFile = new File(TEST_FILE_LOCATION.toFile(), TEST_FILE_NAME);
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 1, 1, "STRING".length()));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 2, 1, "STRING".length() + 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 3, 1, "STRING".length() + 2));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 4, 1, "STRING".length() + 10));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 6, 3, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 7, 9, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 9, 1, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 9, 10, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 10, 1, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 10, 5, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 12, 1, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 12, 5, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 12, 10, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 14, 10, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 14, 5, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 14, 1, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 16, -5, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 19, 100, 1));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 22, 1, 100));
        tokens.add(Token.fileEnd((File)testFile));
        tokens.add(new Token((TokenType)TestTokenType.STRING, testFile, 100, 1, 1));
        String output = TokenPrinter.printTokens(tokens, (File)TEST_FILE_LOCATION.toFile());
        logger.info(output);
        TokenPrinterTest.testOutputCorrectness(TEST_FILE_NAME, tokens, output);
    }

    private static void testOutputCorrectness(String fileName, List<Token> tokens, String output) {
        int lineIndex = -1;
        int tokenIndex = 0;
        for (String line : output.lines().toList()) {
            String[] lineTokens;
            if (line.isEmpty()) continue;
            if (lineIndex == -1) {
                Assertions.assertEquals((Object)fileName, (Object)line);
                lineIndex = 0;
                continue;
            }
            if (line.startsWith(String.valueOf(lineIndex + 1))) {
                ++lineIndex;
                continue;
            }
            line = line.trim();
            for (String lineToken : lineTokens = line.split(TOKEN_SEPARATOR)) {
                if (lineToken.isEmpty()) continue;
                Token currentToken = tokens.get(tokenIndex);
                Assertions.assertTrue((boolean)lineToken.equalsIgnoreCase(currentToken.getType().getDescription()), (String)"expected: %s, actual: %s".formatted(lineToken, currentToken));
                if (currentToken.getLine() != -1) {
                    Assertions.assertEquals((int)lineIndex, (int)currentToken.getLine(), (String)("invalid line for token " + currentToken));
                }
                ++tokenIndex;
            }
        }
        Assertions.assertEquals((int)(tokens.size() - 1), (int)tokenIndex, (String)"incorrect number of tokens printed");
    }

    private static enum TestTokenType implements TokenType
    {
        STRING("STRING");

        private final String description;

        public String getDescription() {
            return this.description;
        }

        private TestTokenType(String description) {
            this.description = description;
        }
    }
}

