/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.kotlin;

import de.jplag.kotlin.KotlinParserAdapter;
import de.jplag.kotlin.KotlinTokenType;
import de.jplag.kotlin.grammar.KotlinParser;
import de.jplag.kotlin.grammar.KotlinParserBaseListener;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JPlagKotlinListener
extends KotlinParserBaseListener {
    private final KotlinParserAdapter parserAdapter;

    public JPlagKotlinListener(KotlinParserAdapter parserAdapter) {
        this.parserAdapter = parserAdapter;
    }

    private void transformToken(KotlinTokenType tokenType, Token token) {
        this.parserAdapter.addToken(tokenType, token.getLine(), token.getCharPositionInLine() + 1, token.getText().length());
    }

    private void transformToken(KotlinTokenType tokenType, Token start, Token end) {
        this.parserAdapter.addToken(tokenType, start.getLine(), start.getCharPositionInLine() + 1, end.getStopIndex() - start.getStartIndex() + 1);
    }

    @Override
    public void enterPackageHeader(KotlinParser.PackageHeaderContext context) {
        this.transformToken(KotlinTokenType.PACKAGE, context.getStart(), context.getStop());
        super.enterPackageHeader(context);
    }

    @Override
    public void enterImportHeader(KotlinParser.ImportHeaderContext context) {
        this.transformToken(KotlinTokenType.IMPORT, context.getStart(), context.getStop());
        super.enterImportHeader(context);
    }

    @Override
    public void enterClassDeclaration(KotlinParser.ClassDeclarationContext context) {
        this.transformToken(KotlinTokenType.CLASS_DECLARATION, context.getStart());
        super.enterClassDeclaration(context);
    }

    @Override
    public void enterObjectDeclaration(KotlinParser.ObjectDeclarationContext context) {
        this.transformToken(KotlinTokenType.OBJECT_DECLARATION, context.getStart(), context.getStop());
        super.enterObjectDeclaration(context);
    }

    @Override
    public void enterCompanionObject(KotlinParser.CompanionObjectContext context) {
        this.transformToken(KotlinTokenType.COMPANION_DECLARATION, context.getStart());
        super.enterCompanionObject(context);
    }

    @Override
    public void enterTypeParameter(KotlinParser.TypeParameterContext context) {
        this.transformToken(KotlinTokenType.TYPE_PARAMETER, context.getStart(), context.getStop());
        super.enterTypeParameter(context);
    }

    @Override
    public void enterPrimaryConstructor(KotlinParser.PrimaryConstructorContext context) {
        this.transformToken(KotlinTokenType.CONSTRUCTOR, context.getStart(), context.getStop());
        super.enterPrimaryConstructor(context);
    }

    @Override
    public void enterClassParameter(KotlinParser.ClassParameterContext context) {
        this.transformToken(KotlinTokenType.PROPERTY_DECLARATION, context.getStart(), context.getStop());
        super.enterClassParameter(context);
    }

    @Override
    public void enterClassBody(KotlinParser.ClassBodyContext context) {
        this.transformToken(KotlinTokenType.CLASS_BODY_BEGIN, context.getStart());
        super.enterClassBody(context);
    }

    @Override
    public void exitClassBody(KotlinParser.ClassBodyContext context) {
        this.transformToken(KotlinTokenType.CLASS_BODY_END, context.getStop());
        super.exitClassBody(context);
    }

    @Override
    public void enterEnumClassBody(KotlinParser.EnumClassBodyContext context) {
        this.transformToken(KotlinTokenType.ENUM_CLASS_BODY_BEGIN, context.getStart());
        super.enterEnumClassBody(context);
    }

    @Override
    public void exitEnumClassBody(KotlinParser.EnumClassBodyContext context) {
        this.transformToken(KotlinTokenType.ENUM_CLASS_BODY_END, context.getStop());
        super.exitEnumClassBody(context);
    }

    @Override
    public void enterEnumEntry(KotlinParser.EnumEntryContext context) {
        this.transformToken(KotlinTokenType.ENUM_ENTRY, context.getStart());
        super.enterEnumEntry(context);
    }

    @Override
    public void enterSecondaryConstructor(KotlinParser.SecondaryConstructorContext context) {
        this.transformToken(KotlinTokenType.CONSTRUCTOR, context.getStart(), context.getStop());
        super.enterSecondaryConstructor(context);
    }

    @Override
    public void enterPropertyDeclaration(KotlinParser.PropertyDeclarationContext context) {
        this.transformToken(KotlinTokenType.PROPERTY_DECLARATION, context.getStart());
        super.enterPropertyDeclaration(context);
    }

    @Override
    public void enterAnonymousInitializer(KotlinParser.AnonymousInitializerContext context) {
        this.transformToken(KotlinTokenType.INITIALIZER, context.getStart());
        super.enterAnonymousInitializer(context);
    }

    @Override
    public void enterInitBlock(KotlinParser.InitBlockContext context) {
        this.transformToken(KotlinTokenType.INITIALIZER_BODY_START, context.getStart());
        super.enterInitBlock(context);
    }

    @Override
    public void exitInitBlock(KotlinParser.InitBlockContext context) {
        this.transformToken(KotlinTokenType.INITIALIZER_BODY_END, context.getStop());
        super.exitInitBlock(context);
    }

    @Override
    public void enterFunctionDeclaration(KotlinParser.FunctionDeclarationContext context) {
        this.transformToken(KotlinTokenType.FUNCTION, context.getStart());
        super.enterFunctionDeclaration(context);
    }

    @Override
    public void enterGetter(KotlinParser.GetterContext context) {
        this.transformToken(KotlinTokenType.GETTER, context.getStart());
        super.enterGetter(context);
    }

    @Override
    public void enterSetter(KotlinParser.SetterContext context) {
        this.transformToken(KotlinTokenType.SETTER, context.getStart());
        super.enterSetter(context);
    }

    @Override
    public void enterFunctionValueParameter(KotlinParser.FunctionValueParameterContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_PARAMETER, context.getStart(), context.getStop());
        super.enterFunctionValueParameter(context);
    }

    @Override
    public void enterFunctionBody(KotlinParser.FunctionBodyContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_BODY_BEGIN, context.getStart());
        super.enterFunctionBody(context);
    }

    @Override
    public void exitFunctionBody(KotlinParser.FunctionBodyContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_BODY_END, context.getStop());
        super.exitFunctionBody(context);
    }

    @Override
    public void enterFunctionLiteral(KotlinParser.FunctionLiteralContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_LITERAL_BEGIN, context.getStart());
        super.enterFunctionLiteral(context);
    }

    @Override
    public void exitFunctionLiteral(KotlinParser.FunctionLiteralContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_LITERAL_END, context.getStop());
        super.exitFunctionLiteral(context);
    }

    @Override
    public void enterForExpression(KotlinParser.ForExpressionContext context) {
        this.transformToken(KotlinTokenType.FOR_EXPRESSION_BEGIN, context.getStart());
        super.enterForExpression(context);
    }

    @Override
    public void exitForExpression(KotlinParser.ForExpressionContext context) {
        this.transformToken(KotlinTokenType.FOR_EXPRESSION_END, context.getStop());
        super.exitForExpression(context);
    }

    @Override
    public void enterIfExpression(KotlinParser.IfExpressionContext context) {
        this.transformToken(KotlinTokenType.IF_EXPRESSION_START, context.getStart());
        super.enterIfExpression(context);
    }

    @Override
    public void exitIfExpression(KotlinParser.IfExpressionContext context) {
        this.transformToken(KotlinTokenType.IF_EXPRESSION_END, context.getStop());
        super.exitIfExpression(context);
    }

    @Override
    public void enterWhileExpression(KotlinParser.WhileExpressionContext context) {
        this.transformToken(KotlinTokenType.WHILE_EXPRESSION_START, context.getStart());
        super.enterWhileExpression(context);
    }

    @Override
    public void exitWhileExpression(KotlinParser.WhileExpressionContext context) {
        this.transformToken(KotlinTokenType.WHILE_EXPRESSION_END, context.getStop());
        super.exitWhileExpression(context);
    }

    @Override
    public void enterDoWhileExpression(KotlinParser.DoWhileExpressionContext context) {
        this.transformToken(KotlinTokenType.DO_WHILE_EXPRESSION_START, context.getStart());
        super.enterDoWhileExpression(context);
    }

    @Override
    public void exitDoWhileExpression(KotlinParser.DoWhileExpressionContext context) {
        this.transformToken(KotlinTokenType.DO_WHILE_EXPRESSION_END, context.getStop());
        super.exitDoWhileExpression(context);
    }

    @Override
    public void enterTryExpression(KotlinParser.TryExpressionContext context) {
        this.transformToken(KotlinTokenType.TRY_EXPRESSION, context.getStart());
        super.enterTryExpression(context);
    }

    @Override
    public void enterTryBody(KotlinParser.TryBodyContext ctx) {
        this.transformToken(KotlinTokenType.TRY_BODY_START, ctx.getStart());
        super.enterTryBody(ctx);
    }

    @Override
    public void exitTryBody(KotlinParser.TryBodyContext ctx) {
        this.transformToken(KotlinTokenType.TRY_BODY_END, ctx.getStop());
        super.exitTryBody(ctx);
    }

    @Override
    public void enterCatchStatement(KotlinParser.CatchStatementContext context) {
        this.transformToken(KotlinTokenType.CATCH, context.getStart());
        super.enterCatchStatement(context);
    }

    @Override
    public void enterCatchBody(KotlinParser.CatchBodyContext context) {
        this.transformToken(KotlinTokenType.CATCH_BODY_START, context.getStart());
        super.enterCatchBody(context);
    }

    @Override
    public void exitCatchBody(KotlinParser.CatchBodyContext context) {
        this.transformToken(KotlinTokenType.CATCH_BODY_END, context.getStop());
        super.exitCatchBody(context);
    }

    @Override
    public void enterFinallyStatement(KotlinParser.FinallyStatementContext context) {
        this.transformToken(KotlinTokenType.FINALLY, context.getStart());
        super.enterFinallyStatement(context);
    }

    @Override
    public void enterFinallyBody(KotlinParser.FinallyBodyContext context) {
        this.transformToken(KotlinTokenType.FINALLY_BODY_START, context.getStart());
        super.enterFinallyBody(context);
    }

    @Override
    public void exitFinallyBody(KotlinParser.FinallyBodyContext context) {
        this.transformToken(KotlinTokenType.FINALLY_BODY_END, context.getStop());
        super.exitFinallyBody(context);
    }

    @Override
    public void enterWhenExpression(KotlinParser.WhenExpressionContext context) {
        this.transformToken(KotlinTokenType.WHEN_EXPRESSION_START, context.getStart());
        super.enterWhenExpression(context);
    }

    @Override
    public void exitWhenExpression(KotlinParser.WhenExpressionContext context) {
        this.transformToken(KotlinTokenType.WHEN_EXPRESSION_END, context.getStop());
        super.exitWhenExpression(context);
    }

    @Override
    public void enterWhenCondition(KotlinParser.WhenConditionContext context) {
        this.transformToken(KotlinTokenType.WHEN_CONDITION, context.getStart(), context.getStop());
        super.enterWhenCondition(context);
    }

    @Override
    public void enterControlStructureBody(KotlinParser.ControlStructureBodyContext context) {
        this.transformToken(KotlinTokenType.CONTROL_STRUCTURE_BODY_START, context.getStart());
        super.enterControlStructureBody(context);
    }

    @Override
    public void exitControlStructureBody(KotlinParser.ControlStructureBodyContext context) {
        this.transformToken(KotlinTokenType.CONTROL_STRUCTURE_BODY_END, context.getStop());
        super.exitControlStructureBody(context);
    }

    @Override
    public void enterVariableDeclaration(KotlinParser.VariableDeclarationContext context) {
        this.transformToken(KotlinTokenType.VARIABLE_DECLARATION, context.getStart());
        super.enterVariableDeclaration(context);
    }

    @Override
    public void enterConstructorInvocation(KotlinParser.ConstructorInvocationContext context) {
        this.transformToken(KotlinTokenType.CREATE_OBJECT, context.getStart(), context.getStop());
        super.enterConstructorInvocation(context);
    }

    @Override
    public void enterCallSuffix(KotlinParser.CallSuffixContext context) {
        this.transformToken(KotlinTokenType.FUNCTION_INVOCATION, context.getStart(), context.getStop());
        super.enterCallSuffix(context);
    }

    @Override
    public void enterAssignmentOperator(KotlinParser.AssignmentOperatorContext context) {
        this.transformToken(KotlinTokenType.ASSIGNMENT, context.getStart());
        super.enterAssignmentOperator(context);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token token = node.getSymbol();
        String tokenText = token.getText();
        if (tokenText.contains("@")) {
            tokenText = tokenText.substring(0, tokenText.indexOf("@"));
        }
        Optional<Object> type = switch (tokenText) {
            case "throw" -> Optional.of(KotlinTokenType.THROW);
            case "return" -> Optional.of(KotlinTokenType.RETURN);
            case "continue" -> Optional.of(KotlinTokenType.CONTINUE);
            case "break" -> Optional.of(KotlinTokenType.BREAK);
            default -> Optional.empty();
        };
        type.ifPresent(tokenType -> this.transformToken((KotlinTokenType)((Object)tokenType), token));
    }
}

