/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.kotlin;

import de.jplag.ParsingException;
import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.kotlin.KotlinTokenType;
import de.jplag.kotlin.Language;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KotlinLanguageTest {
    private static final String COMPLETE_TEST_FILE = "Complete.kt";
    private static final String EMPTY_OR_SINGLE_LINE_COMMENT = "\\s*(//.*|/\\*.*\\*/)?";
    private static final String DELIMITED_COMMENT_START = "\\s*/\\*(?:(?!\\*/).)*$";
    private static final String DELIMITED_COMMENT_END = ".*\\*/\\s*$";
    private final Logger logger = LoggerFactory.getLogger(KotlinLanguageTest.class);
    private final String[] testFiles = new String[]{"Complete.kt", "Game.kt"};
    private final File testFileLocation = Path.of("src", "test", "resources", "de", "jplag", "kotlin").toFile();
    private Language language;

    KotlinLanguageTest() {
    }

    @BeforeEach
    void setup() {
        this.language = new Language();
    }

    @Test
    void parseTestFiles() throws ParsingException {
        for (String fileName : this.testFiles) {
            List tokens = this.language.parse(Set.of(new File(this.testFileLocation, fileName)));
            String output = TokenPrinter.printTokens((List)tokens, (File)this.testFileLocation);
            this.logger.info(output);
            this.testSourceCoverage(fileName, tokens);
            if (!fileName.equals(COMPLETE_TEST_FILE)) continue;
            this.testTokenCoverage(tokens, fileName);
        }
    }

    private void testSourceCoverage(String fileName, List<Token> tokens) {
        File testFile = new File(this.testFileLocation, fileName);
        try {
            List<String> lines = Files.readAllLines(testFile.toPath());
            int[] codeLines = this.getCodeLines(lines);
            int[] tokenLines = tokens.stream().mapToInt(Token::getLine).filter(line -> line != -1).distinct().toArray();
            if (codeLines.length > tokenLines.length) {
                OptionalInt diffLine = IntStream.range(0, codeLines.length).dropWhile(lineIdx -> lineIdx < tokenLines.length && codeLines[lineIdx] == tokenLines[lineIdx]).findFirst();
                diffLine.ifPresent(lineIdx -> Assertions.fail((String)"Line %d of file '%s' is not represented in the token list.".formatted(codeLines[lineIdx], fileName)));
            }
            Assertions.assertArrayEquals((int[])codeLines, (int[])tokenLines);
        }
        catch (IOException exception) {
            this.logger.info("Error while reading test file %s".formatted(fileName), (Throwable)exception);
            Assertions.fail();
        }
    }

    private int[] getCodeLines(List<String> lines) {
        Object state = new Object(){
            boolean insideComment = false;
        };
        IntStream codeLines = IntStream.rangeClosed(1, lines.size()).sequential().filter(arg_0 -> KotlinLanguageTest.lambda$getCodeLines$3(lines, state, arg_0));
        return codeLines.toArray();
    }

    private void testTokenCoverage(List<Token> tokens, String fileName) {
        Set annotatedTokens = tokens.stream().map(Token::getType).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)annotatedTokens.contains(SharedTokenType.FILE_END));
        Set annotatedKotlinTokens = annotatedTokens.stream().filter(KotlinTokenType.class::isInstance).collect(Collectors.toSet());
        KotlinTokenType[] allKotlinTokens = KotlinTokenType.values();
        List<KotlinTokenType> missingKotlinTokens = Arrays.stream(allKotlinTokens).filter(token -> !annotatedKotlinTokens.contains(token)).toList();
        Assertions.assertTrue((boolean)missingKotlinTokens.isEmpty(), (String)("The following kotlin tokens are missing in the code example '%s':\n".formatted(fileName) + String.join((CharSequence)"\n", missingKotlinTokens.stream().map(KotlinTokenType::getDescription).toList())));
    }

    private static /* synthetic */ boolean lambda$getCodeLines$3(List lines, 1 state, int idx) {
        String line = (String)lines.get(idx - 1);
        if (line.matches(EMPTY_OR_SINGLE_LINE_COMMENT)) {
            return false;
        }
        if (line.matches(DELIMITED_COMMENT_START)) {
            state.insideComment = true;
            return false;
        }
        if (state.insideComment) {
            if (line.matches(DELIMITED_COMMENT_END)) {
                state.insideComment = false;
            }
            return false;
        }
        return true;
    }
}

