/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.java;

import de.jplag.AbstractParser;
import de.jplag.CriticalParsingException;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.java.JavacAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.tools.ToolProvider;

public class Parser
extends AbstractParser {
    private static final String JDK_ERROR_MESSAGE = "Cannot parse as 'javac' is not available. Ensure a full JDK is installed.";
    private List<Token> tokens;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.ensureJavacIsAvailable();
        this.tokens = new ArrayList<Token>();
        new JavacAdapter().parseFiles(files, this);
        this.logger.debug("--- token semantics ---");
        for (Token token : this.tokens) {
            this.logger.debug("{} | {} | {}", new Object[]{token.getLine(), token.getType().getDescription(), token.getSemantics()});
        }
        return this.tokens;
    }

    private void ensureJavacIsAvailable() throws CriticalParsingException {
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new CriticalParsingException(JDK_ERROR_MESSAGE);
        }
    }

    public void add(Token token) {
        this.tokens.add(token);
    }
}

