/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Trees;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.java.FixedSourcePositions;
import de.jplag.java.Parser;
import de.jplag.java.TokenGeneratingTreeScanner;
import de.jplag.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;

public class JavacAdapter {
    private static final JavaCompiler javac = ToolProvider.getSystemJavaCompiler();

    public void parseFiles(Set<File> files, Parser parser) throws ParsingException {
        DiagnosticCollector<Object> listener = new DiagnosticCollector<Object>();
        ArrayList<ParsingException> parsingExceptions = new ArrayList<ParsingException>();
        Charset guessedCharset = FileUtils.detectCharsetFromMultiple(files);
        try (StandardJavaFileManager fileManager = javac.getStandardFileManager(listener, null, guessedCharset);){
            Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjectsFromFiles(files);
            JavaCompiler.CompilationTask task = javac.getTask(null, fileManager, listener, List.of("-proc:none", "--enable-preview", "--release=21"), null, javaFiles);
            Trees trees = Trees.instance(task);
            FixedSourcePositions positions = new FixedSourcePositions(trees.getSourcePositions());
            for (CompilationUnitTree compilationUnitTree : this.executeCompilationTask(task, parser.logger)) {
                File file = new File(compilationUnitTree.getSourceFile().toUri());
                LineMap map = compilationUnitTree.getLineMap();
                TokenGeneratingTreeScanner scanner = new TokenGeneratingTreeScanner(file, parser, map, positions, compilationUnitTree);
                compilationUnitTree.accept(scanner, null);
                parser.add(Token.semanticFileEnd((File)file));
            }
        }
        catch (Exception exception) {
            throw new ParsingException(null, exception.getMessage(), (Throwable)exception);
        }
        parsingExceptions.addAll(this.processErrors(listener));
        if (!parsingExceptions.isEmpty()) {
            throw ParsingException.wrappingExceptions(parsingExceptions);
        }
    }

    private Iterable<? extends CompilationUnitTree> executeCompilationTask(JavaCompiler.CompilationTask task, Logger logger) {
        Iterable<Object> abstractSyntaxTrees = Collections.emptyList();
        try {
            abstractSyntaxTrees = ((JavacTask)task).parse();
        }
        catch (IOException exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
        return abstractSyntaxTrees;
    }

    private List<ParsingException> processErrors(DiagnosticCollector<Object> listener) {
        return listener.getDiagnostics().stream().filter(it -> it.getKind() == Diagnostic.Kind.ERROR).map(diagnosticItem -> {
            File file = null;
            Object patt0$temp = diagnosticItem.getSource();
            if (patt0$temp instanceof JavaFileObject) {
                JavaFileObject fileObject = (JavaFileObject)patt0$temp;
                file = new File(fileObject.toUri());
            }
            return new ParsingException(file, diagnosticItem.toString());
        }).toList();
    }
}

