/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.model.parser;

import de.jplag.ParsingException;
import de.jplag.emf.dynamic.parser.DynamicEcoreParser;
import de.jplag.emf.util.AbstractModelView;
import de.jplag.emf.util.EMFUtil;
import de.jplag.emf.util.GenericEmfTreeView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelParser
extends DynamicEcoreParser {
    private static final Logger logger = LoggerFactory.getLogger(DynamicModelParser.class);
    private static final String VIEW_FILE_WARNING = "Skipping view file {} as submission!";
    private static final String METAPACKAGE_WARNING = "Loading model instance {} without any metamodel!";
    private static final String METAPACKAGE_ERROR = "Error, not a metapackage: ";
    private static final String METAMODEL_LOADING_ERROR = "Could not load metamodel file!";
    private static final List<EPackage> metapackages = new ArrayList<EPackage>();
    private static final String ALL_EXTENSIONS = "*";

    public DynamicModelParser() {
        EMFUtil.registerModelExtension((String)ALL_EXTENSIONS);
    }

    protected void parseModelFile(File file, boolean normalize) throws ParsingException {
        if (file.getName().endsWith(".ecore")) {
            this.parseMetamodelFile(file);
        } else if (file.getName().endsWith(".emfatic")) {
            logger.warn(VIEW_FILE_WARNING, (Object)file.getName());
        } else {
            if (metapackages.isEmpty()) {
                logger.warn(METAPACKAGE_WARNING, (Object)file.getName());
            }
            super.parseModelFile(file, normalize);
        }
    }

    protected String getCorrespondingViewFileExtension() {
        return ".emfatic";
    }

    protected AbstractModelView createView(File file, Resource modelResource) {
        return new GenericEmfTreeView(file, modelResource);
    }

    private void parseMetamodelFile(File file) throws ParsingException {
        metapackages.clear();
        Resource modelResource = EMFUtil.loadModelResource((File)file);
        if (modelResource == null) {
            throw new ParsingException(file, METAMODEL_LOADING_ERROR);
        }
        for (EObject object : modelResource.getContents()) {
            if (object instanceof EPackage) {
                EPackage ePackage = (EPackage)object;
                metapackages.add(ePackage);
                continue;
            }
            logger.error(METAPACKAGE_ERROR, (Object)object);
        }
        EMFUtil.registerEPackageURIs(metapackages);
    }
}

