/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.model;

import de.jplag.ParsingException;
import de.jplag.TokenPrinter;
import de.jplag.emf.model.EmfModelLanguage;
import de.jplag.testutils.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimalModelInstanceTest {
    private final Logger logger = LoggerFactory.getLogger(MinimalModelInstanceTest.class);
    private static final Path BASE_PATH = Path.of("src", "test", "resources", "de", "jplag", "books");
    private static final String[] TEST_SUBJECTS = new String[]{"bookStore.ecore", "bookStore.xml", "bookStore2.xml"};
    private EmfModelLanguage language;
    private File baseDirectory;

    MinimalModelInstanceTest() {
    }

    @BeforeEach
    public void setUp() {
        this.language = new EmfModelLanguage();
        this.baseDirectory = BASE_PATH.toFile();
        FileUtil.assertDirectory((File)this.baseDirectory, (String[])TEST_SUBJECTS);
    }

    @Test
    @DisplayName(value="Test tokens extracted from generated example instances")
    void testBookStoreInstances() {
        File baseFile = new File(BASE_PATH.toString());
        ArrayList<File> baseFiles = new ArrayList<File>(Arrays.asList(baseFile.listFiles()));
        LinkedHashSet sortedFiles = new LinkedHashSet(this.language.customizeSubmissionOrder(baseFiles));
        try {
            List tokens = this.language.parse(sortedFiles, true);
            Assertions.assertNotEquals((int)0, (int)tokens.size());
            this.logger.debug(TokenPrinter.printTokens((List)tokens, (File)this.baseDirectory, Optional.of(".emfatic")));
            this.logger.info("Parsed tokens: " + String.valueOf(tokens));
            Assertions.assertEquals((int)7, (int)tokens.size());
        }
        catch (ParsingException e) {
            Assertions.fail((String)("Parsing failed: " + e.getMessage()), (Throwable)e);
        }
    }

    @AfterEach
    public void tearDown() {
        FileUtil.clearFiles((File)new File(BASE_PATH.toString()), (String)".emfatic");
    }
}

