/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class BookStoreFactory {
    private static final String MODEL_NAME = "bookStore.xml";
    private static final String METAMODEL_NAME = "bookStore.ecore";

    public static void generateAll(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        BookStoreFactory.createMetamodelAndModelInstance(filePath);
    }

    private static void createMetamodelAndModelInstance(String baseBath) {
        EcoreFactory theCoreFactory = EcoreFactory.eINSTANCE;
        EClass bookStoreEClass = theCoreFactory.createEClass();
        bookStoreEClass.setName("BookStore");
        EClass bookEClass = theCoreFactory.createEClass();
        bookEClass.setName("Book");
        EPackage bookStoreEPackage = theCoreFactory.createEPackage();
        bookStoreEPackage.setName("BookStorePackage");
        bookStoreEPackage.setNsPrefix("bookStore");
        bookStoreEPackage.setNsURI("http:///com.ibm.dynamic.example.bookstore.ecore");
        EcorePackage theCorePackage = EcorePackage.eINSTANCE;
        EAttribute bookStoreOwner = theCoreFactory.createEAttribute();
        bookStoreOwner.setName("owner");
        bookStoreOwner.setEType((EClassifier)theCorePackage.getEString());
        EAttribute bookStoreLocation = theCoreFactory.createEAttribute();
        bookStoreLocation.setName("location");
        bookStoreLocation.setEType((EClassifier)theCorePackage.getEString());
        EReference bookStore_Books = theCoreFactory.createEReference();
        bookStore_Books.setName("books");
        bookStore_Books.setEType((EClassifier)bookEClass);
        bookStore_Books.setUpperBound(-1);
        bookStore_Books.setContainment(true);
        EAttribute bookName = theCoreFactory.createEAttribute();
        bookName.setName("name");
        bookName.setEType((EClassifier)theCorePackage.getEString());
        EAttribute bookISBN = theCoreFactory.createEAttribute();
        bookISBN.setName("isbn");
        bookISBN.setID(true);
        bookISBN.setEType((EClassifier)theCorePackage.getEInt());
        bookStoreEClass.getEStructuralFeatures().add((Object)bookStoreOwner);
        bookStoreEClass.getEStructuralFeatures().add((Object)bookStoreLocation);
        bookStoreEClass.getEStructuralFeatures().add((Object)bookStore_Books);
        bookEClass.getEStructuralFeatures().add((Object)bookName);
        bookEClass.getEStructuralFeatures().add((Object)bookISBN);
        bookStoreEPackage.getEClassifiers().add((Object)bookStoreEClass);
        bookStoreEPackage.getEClassifiers().add((Object)bookEClass);
        EFactory bookFactoryInstance = bookStoreEPackage.getEFactoryInstance();
        EObject bookObject = bookFactoryInstance.create(bookEClass);
        EObject bookStoreObject = bookFactoryInstance.create(bookStoreEClass);
        bookStoreObject.eSet((EStructuralFeature)bookStoreOwner, (Object)"David Brown");
        bookStoreObject.eSet((EStructuralFeature)bookStoreLocation, (Object)"Street#12, Top Town, NY");
        ((List)bookStoreObject.eGet((EStructuralFeature)bookStore_Books)).add(bookObject);
        bookObject.eSet((EStructuralFeature)bookName, (Object)"Harry Potter and the Deathly Hallows");
        bookObject.eSet((EStructuralFeature)bookISBN, (Object)157221);
        BookStoreFactory.persist(baseBath, bookStoreObject, MODEL_NAME, "*");
        BookStoreFactory.persist(baseBath, (EObject)bookStoreEPackage, METAMODEL_NAME, "ecore");
    }

    private static void persist(String baseBath, EObject eObject, String name, String extension) {
        ResourceSetImpl metaResourceSet = new ResourceSetImpl();
        metaResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(extension, new XMLResourceFactoryImpl());
        Resource metaResource = metaResourceSet.createResource(URI.createFileURI((String)(baseBath + File.separator + name)));
        metaResource.getContents().add((Object)eObject);
        try {
            metaResource.save(null);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

