/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.TokenTrace;
import de.jplag.emf.MetamodelToken;
import de.jplag.emf.util.AbstractMetamodelVisitor;
import de.jplag.emf.util.AbstractModelView;
import de.jplag.emf.util.ModelingElementIdentifierManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class GenericEmfTreeView
extends AbstractModelView {
    private final List<String> lines = new ArrayList<String>();
    private final Map<EObject, TokenTrace> objectToLine = new HashMap<EObject, TokenTrace>();
    private final ModelingElementIdentifierManager identifierManager = new ModelingElementIdentifierManager();

    public GenericEmfTreeView(File file, Resource modelResource) {
        super(file);
        TreeViewBuilder visitor = new TreeViewBuilder();
        modelResource.getContents().forEach(visitor::visit);
    }

    @Override
    public MetamodelToken convertToMetadataEnrichedToken(MetamodelToken token) {
        Optional<EObject> optionalEObject = token.getEObject();
        if (optionalEObject.isPresent()) {
            EObject object = optionalEObject.get();
            TokenTrace trace = this.objectToLine.get(object);
            return new MetamodelToken(token.getType(), token.getFile(), trace, optionalEObject);
        }
        return new MetamodelToken(token.getType(), token.getFile());
    }

    private final class TreeViewBuilder
    extends AbstractMetamodelVisitor {
        private static final String IDENTIFIER_PREFIX = " #";
        private static final String VALUE_ASSIGNMENT = "=";
        private static final String COLLECTION_PREFIX = "[";
        private static final String COLLECTION_SUFFIX = "]";
        private static final String COLLECTION_DELIMITER = ", ";
        private static final int ABBREVIATION_LIMIT = 20;
        private static final String ABBREVIATION_SUFFIX = "...";
        private static final String TEXT_AFFIX = "\"";
        private static final String IDENTIFIER_REGEX = "name|identifier";
        private static final String INDENTATION = "  ";

        private TreeViewBuilder() {
        }

        @Override
        protected void visitEObject(EObject eObject) {
            String prefix = INDENTATION.repeat(this.getCurrentTreeDepth());
            StringBuilder line = new StringBuilder(prefix);
            line.append(eObject.eClass().getName());
            line.append(IDENTIFIER_PREFIX);
            line.append(GenericEmfTreeView.this.identifierManager.getIdentifier(eObject));
            this.visitStructuralFeatures(eObject, line);
            GenericEmfTreeView.this.lines.add(line.toString());
            GenericEmfTreeView.this.viewBuilder.append(String.valueOf(line) + System.lineSeparator());
            TokenTrace trace = new TokenTrace(GenericEmfTreeView.this.lines.size(), prefix.length() + 1, line.toString().trim().length());
            GenericEmfTreeView.this.objectToLine.put(eObject, trace);
        }

        private void visitStructuralFeatures(EObject eObject, StringBuilder line) {
            EList structuralFeatures = eObject.eClass().getEAllStructuralFeatures();
            if (!structuralFeatures.isEmpty()) {
                line.append(": ");
                StringJoiner joiner = new StringJoiner(COLLECTION_DELIMITER);
                for (EStructuralFeature feature : structuralFeatures) {
                    Object value = eObject.eGet(feature);
                    String name = this.featureValueToString(value);
                    if (name == null) continue;
                    joiner.add(feature.getName() + VALUE_ASSIGNMENT + name);
                }
                line.append(joiner.toString());
            }
        }

        private String featureValueToString(Object value) {
            Object name = null;
            if (value != null) {
                if (value instanceof EObject) {
                    EObject featureValue = (EObject)value;
                    List<String> valueIdentifiers = TreeViewBuilder.deriveNameOrIdentifers(featureValue);
                    name = !valueIdentifiers.isEmpty() ? TEXT_AFFIX + valueIdentifiers.get(0) + TEXT_AFFIX : featureValue.eClass().getName() + IDENTIFIER_PREFIX + GenericEmfTreeView.this.identifierManager.getIdentifier(featureValue);
                } else if (value instanceof Collection) {
                    Collection multipleValues = (Collection)value;
                    name = this.valueListToString(multipleValues);
                } else {
                    name = value.toString();
                    name = ((String)name).length() > 20 ? ((String)name).substring(0, 20) + ABBREVIATION_SUFFIX : name;
                    name = TEXT_AFFIX + (String)name + TEXT_AFFIX;
                }
            }
            return name;
        }

        private String valueListToString(Collection<?> multipleValues) {
            Object name = null;
            if (!multipleValues.isEmpty()) {
                name = COLLECTION_PREFIX;
                StringJoiner joiner = new StringJoiner(COLLECTION_DELIMITER);
                for (Object innerValue : multipleValues) {
                    joiner.add(this.featureValueToString(innerValue));
                }
                name = (String)name + joiner.toString() + COLLECTION_SUFFIX;
            }
            return name;
        }

        private static List<String> deriveNameOrIdentifers(EObject eObject) {
            ArrayList<String> names = new ArrayList<String>();
            if (eObject instanceof ENamedElement) {
                ENamedElement element = (ENamedElement)eObject;
                names.add(element.getName());
            } else {
                for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                    if (!feature.getName().toLowerCase().matches(IDENTIFIER_REGEX) || eObject.eGet(feature) == null) continue;
                    names.add(eObject.eGet(feature).toString());
                }
            }
            return names;
        }
    }
}

