/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenTrace;
import de.jplag.TokenType;
import de.jplag.emf.MetamodelToken;
import de.jplag.emf.MetamodelTokenType;
import de.jplag.emf.util.AbstractMetamodelVisitor;
import de.jplag.emf.util.AbstractModelView;
import de.jplag.emf.util.EMFUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfatic.core.generator.emfatic.Writer;

public final class EmfaticModelView
extends AbstractModelView {
    private static final String PACKAGE_REGEX = "package\\s+\\S+;";
    private static final String TYPE_KEYWORD_REGEX = "(package |class |datatype |enum )";
    private static final String FEATURE_KEYWORD_REGEX = "(.*attr .*|op .*|.*ref .*|.*val .*).*";
    private static final String TYPE_SUFFIX_REGEX = "(;| extends| \\{)";
    private static final String LINE_SUFFIX_REGEX = ";";
    private static final char CLOSING_CHAR = '}';
    private static final String ANYTHING_REGEX = ".*";
    private final List<String> lines;
    private final List<String> hashedLines;
    private final Map<ENamedElement, Integer> elementToLine = new HashMap<ENamedElement, Integer>();
    private final EcoreUtil.Copier modelCopier;
    private int lastLineIndex;
    private final int rootPackageIndex;

    public EmfaticModelView(File file, Resource modelResource) throws ParsingException {
        super(file);
        this.lines = this.generateEmfaticCode(this.viewBuilder, modelResource);
        this.modelCopier = new EcoreUtil.Copier();
        Resource copiedResource = EMFUtil.copyModel(modelResource, this.modelCopier);
        this.replaceElementNamesWithHashes(copiedResource);
        this.hashedLines = this.generateEmfaticCode(new StringBuilder(), copiedResource);
        this.rootPackageIndex = this.findIndexOfRootPackage(this.hashedLines);
    }

    @Override
    public MetamodelToken convertToMetadataEnrichedToken(MetamodelToken token) {
        int lineIndex = this.calculateLineIndexOf(token);
        String line = this.lines.get(lineIndex);
        int columnIndex = this.indentationOf(line);
        int length = line.length() - columnIndex;
        TokenTrace trace = new TokenTrace(++lineIndex, columnIndex += columnIndex == -1 ? 0 : 1, length);
        return new MetamodelToken(token.getType(), token.getFile(), trace, token.getEObject());
    }

    private final void replaceElementNamesWithHashes(Resource copiedResource) {
        AbstractMetamodelVisitor renamer = new AbstractMetamodelVisitor(this){

            @Override
            protected void visitENamedElement(ENamedElement eNamedElement) {
                eNamedElement.setName(Integer.toString(eNamedElement.hashCode()));
            }
        };
        copiedResource.getContents().forEach(renamer::visit);
    }

    private final List<String> generateEmfaticCode(StringBuilder builder, Resource modelResource) throws ParsingException {
        Writer writer = new Writer();
        try {
            String code = writer.write(modelResource, null, null);
            builder.append(code);
        }
        catch (Exception exception) {
            throw new ParsingException(this.file, "Emfatic view could not be generated!", (Throwable)exception);
        }
        return builder.toString().lines().toList();
    }

    private final int findIndexOfRootPackage(List<String> lines) {
        for (int index = 0; index < lines.size(); ++index) {
            if (!lines.get(index).matches(PACKAGE_REGEX)) continue;
            return index;
        }
        return -1;
    }

    private int calculateLineIndexOf(MetamodelToken token) {
        ENamedElement element;
        EObject eObject;
        int line = -1;
        Optional<EObject> optionalEObject = token.getEObject();
        if (optionalEObject.isPresent() && (eObject = optionalEObject.get()) instanceof ENamedElement && (line = this.lineIndexOf(element = (ENamedElement)eObject)) != -1 && this.isEndToken(token)) {
            line = this.findEndIndexOf(line);
        }
        if (line == -1) {
            return this.lastLineIndex;
        }
        this.lastLineIndex = line;
        return line;
    }

    private int findEndIndexOf(int declarationIndex) {
        int indentation = this.indentationOf(this.lines.get(declarationIndex));
        if (declarationIndex > this.rootPackageIndex) {
            for (int i = declarationIndex + 1; i < this.lines.size(); ++i) {
                String nextLine = this.lines.get(i);
                if (nextLine.length() <= indentation || '}' != nextLine.charAt(indentation)) continue;
                return i;
            }
        }
        return this.lastLineIndex;
    }

    private boolean isEndToken(Token token) {
        MetamodelTokenType type;
        TokenType tokenType = token.getType();
        return tokenType instanceof MetamodelTokenType && (type = (MetamodelTokenType)tokenType).isEndToken();
    }

    private int indentationOf(String beginLine) {
        return beginLine.indexOf(beginLine.stripLeading());
    }

    private int lineIndexOf(ENamedElement element) {
        return this.elementToLine.computeIfAbsent(element, this::findLineIndexOf);
    }

    private int findLineIndexOf(ENamedElement element) {
        String hash = Integer.toString(((EObject)this.modelCopier.get((Object)element)).hashCode());
        for (int index = 0; index < this.hashedLines.size(); ++index) {
            String line = this.hashedLines.get(index);
            String trimmedLine = line.stripLeading();
            if (!line.contains(hash) || !this.isDeclaration(element, hash, trimmedLine)) continue;
            return index;
        }
        return -1;
    }

    private boolean isDeclaration(ENamedElement element, String hash, String line) {
        return this.isStructuralFeature(element, hash, line) || this.isTypedElement(element, hash, line) || this.isEnumLiteral(element, hash, line) || this.isType(hash, line);
    }

    private boolean isType(String hash, String line) {
        return line.matches(TYPE_KEYWORD_REGEX + hash + "(;| extends| \\{).*");
    }

    private boolean isEnumLiteral(ENamedElement element, String hash, String line) {
        return element instanceof EEnumLiteral && line.matches(hash + ANYTHING_REGEX);
    }

    private boolean isTypedElement(ENamedElement element, String hash, String line) {
        return element instanceof EOperation && element instanceof EParameter && line.matches(FEATURE_KEYWORD_REGEX + hash + ANYTHING_REGEX);
    }

    private boolean isStructuralFeature(ENamedElement element, String hash, String line) {
        return element instanceof ETypedElement && line.matches(FEATURE_KEYWORD_REGEX + hash + LINE_SUFFIX_REGEX);
    }
}

