/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EMFUtil {
    private static final Logger logger = LoggerFactory.getLogger(EMFUtil.class);

    private EMFUtil() {
    }

    public static void registerModelExtension(String extension) {
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionMap = registry.getExtensionToFactoryMap();
        extensionMap.put(extension, new XMIResourceFactoryImpl());
    }

    public static void registerEcoreExtension() {
        EcorePackage.eINSTANCE.eClass();
        EMFUtil.registerModelExtension("ecore");
    }

    public static void registerEPackageURIs(Collection<EPackage> ePackages) {
        ePackages.forEach(it -> EPackage.Registry.INSTANCE.put((Object)it.getNsURI(), it));
    }

    public static Resource loadModelResource(File file) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            return resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        }
        catch (WrappedException exception) {
            logger.error("Could not load {}: {}", (Object)file, (Object)exception.getCause().getMessage());
            return null;
        }
    }

    public static Resource copyModel(Resource modelResource, EcoreUtil.Copier modelCopier) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource copy = resourceSet.createResource(modelResource.getURI());
        Collection result = modelCopier.copyAll((Collection)modelResource.getContents());
        modelCopier.copyReferences();
        copy.getContents().addAll(result);
        return copy;
    }

    public static Resource copyModel(Resource modelResource) {
        return EMFUtil.copyModel(modelResource, new EcoreUtil.Copier());
    }
}

