/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.emf.MetamodelToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelView {
    protected final File file;
    protected final Logger logger;
    protected final StringBuilder viewBuilder;

    protected AbstractModelView(File file) {
        this.file = file;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.viewBuilder = new StringBuilder();
    }

    public abstract MetamodelToken convertToMetadataEnrichedToken(MetamodelToken var1);

    public void writeToFile(String suffix) {
        File treeViewFile = new File(String.valueOf(this.file) + suffix);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(treeViewFile));){
            if (!treeViewFile.createNewFile()) {
                this.logger.warn("Overwriting tree view file: {}", (Object)treeViewFile);
            }
            writer.append(this.viewBuilder.toString());
        }
        catch (IOException exception) {
            this.logger.error("Could not write tree view file!", (Throwable)exception);
        }
    }
}

