/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.parser;

import de.jplag.TokenType;
import de.jplag.emf.MetamodelTokenType;
import de.jplag.emf.parser.EcoreParser;
import de.jplag.emf.parser.MetamodelElementTokenizer;
import de.jplag.emf.parser.ModelingElementTokenizer;
import de.jplag.emf.util.AbstractMetamodelVisitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypeParameter;

public class MetamodelTokenGenerator
extends AbstractMetamodelVisitor {
    private final EcoreParser parser;
    private final ModelingElementTokenizer tokenizer;

    public MetamodelTokenGenerator(EcoreParser parser) {
        this.parser = parser;
        this.tokenizer = new MetamodelElementTokenizer();
    }

    @Override
    protected void visitEObject(EObject eObject) {
        this.tokenizer.element2OptionalToken(eObject).ifPresent(it -> this.parser.addToken((TokenType)it, eObject));
    }

    @Override
    protected void visitEOperation(EOperation eOperation) {
        if (eOperation.getEType() != null) {
            this.parser.addToken(MetamodelTokenType.RETURN_TYPE, (EObject)eOperation);
        }
        eOperation.getEExceptions().forEach(it -> this.parser.addToken(MetamodelTokenType.THROWS_DECLARATION, (EObject)it));
    }

    @Override
    protected void visitETypeParameter(ETypeParameter eTypeParameter) {
        eTypeParameter.getEBounds().forEach(it -> this.parser.addToken(MetamodelTokenType.BOUND, (EObject)it));
    }

    @Override
    protected void leaveEClass(EClass eClass) {
        if (eClass.isInterface()) {
            this.parser.addToken(MetamodelTokenType.INTERFACE_END, (EObject)eClass);
        } else if (eClass.isAbstract()) {
            this.parser.addToken(MetamodelTokenType.ABSTRACT_CLASS_END, (EObject)eClass);
        } else {
            this.parser.addToken(MetamodelTokenType.CLASS_END, (EObject)eClass);
        }
    }

    @Override
    protected void leaveEPackage(EPackage ePackage) {
        this.parser.addToken(MetamodelTokenType.PACKAGE_END, (EObject)ePackage);
    }

    @Override
    protected void leaveEEnum(EEnum eEnum) {
        this.parser.addToken(MetamodelTokenType.ENUM_END, (EObject)eEnum);
    }
}

